<?php
session_start();

if (!isset($_SESSION['authenticated']) || $_SESSION['authenticated'] !== true) {
    header('Location: login.php');
    exit;
}
?>
<!doctype html>
<html lang="fr">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="robots" content="noindex, nofollow, noimageindex, noarchive, nocache, nosnippet">
    <title>🥷 Corleone Control Panel 🥷</title>
    <style>
        /* Général */
        body {
            background-color: #121212;
            color: #c5c6c7;
            font-family: 'Roboto Mono', monospace;
            margin: 0;
            padding: 0;
        }

        h1,
        h2 {
            color: #39ff14;
        }

        .container-fluid {
            margin: 20px auto;
            padding: 20px;
            max-width: 90%;
        }

        /* Table */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        th,
        td {
            padding: 15px;
            text-align: center;
            border: 1px solid #333;
        }

        th {
            background-color: #2e2e2e;
            color: #39ff14;
            font-weight: bold;
            font-size: 1rem;
        }

        td {
            background-color: #1e1e1e;
            color: #c5c6c7;
        }

        tr:nth-child(even) {
            background-color: #2a2a2a;
        }

        tr:hover {
            background-color: #444;
        }

        /* Header */
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 10px 20px;
            background-color: #101010;
            border-bottom: 1px solid #333;
        }

        .header h1 {
            font-size: 1.8rem;
            margin: 0;
        }

        .header .status {
            font-size: 1.1rem;
            color: #ff6666;
        }

        /* Formulaire */
        .form-container {
            background-color: #1e1e1e;
            padding: 20px;
            border: 1px solid #333;
            border-radius: 10px;
            margin-bottom: 20px;
            display: flex;
            flex-wrap: wrap;
            justify-content: space-between;
            align-items: center;
        }

        .form-container input[type="text"] {
            flex: 1;
            margin-right: 10px;
            padding: 10px;
            font-size: 1rem;
            border: 1px solid #333;
            background-color: #121212;
            color: #39ff14;
            border-radius: 5px;
        }

        .form-container input[type="text"]::placeholder {
            color: #555;
        }

        .form-container .btn {
            padding: 10px 20px;
            font-size: 1rem;
            color: #39ff14;
            background-color: #111;
            border: 2px solid #39ff14;
            text-transform: uppercase;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .form-container .btn:hover {
            background-color: #39ff14;
            color: #111;
        }

        /* Boutons d'action */
        .buttons {
            display: flex;
            justify-content: space-evenly;
            gap: 20px;
            margin-top: 20px;
        }

        .buttons .btn {
            padding: 15px 30px;
            font-size: 1rem;
            color: #39ff14;
            background-color: #111;
            border: 2px solid #39ff14;
            text-transform: uppercase;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .buttons .btn:hover {
            background-color: #39ff14;
            color: #111;
        }

        /* Boutons en rouge pour Ban et Clear Logs */
        .buttons .btn-danger {
            color: #ff4d4d;
            border-color: #ff4d4d;
        }

        .buttons .btn-danger:hover {
            background-color: #ff4d4d;
            color: #fff;
        }

        /* Notifications */
        .notifications {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1000;
            display: flex;
            flex-direction: column;
            gap: 10px;
        }

        .notification {
            background-color: #1e1e1e;
            color: #39ff14;
            padding: 15px 20px;
            border-left: 5px solid #39ff14;
            border-radius: 5px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.5);
            font-size: 0.9rem;
            animation: slideIn 0.5s ease-out, fadeOut 5s ease forwards;
        }

        @keyframes slideIn {
            from {
                transform: translateX(100%);
                opacity: 0;
            }

            to {
                transform: translateX(0);
                opacity: 1;
            }
        }

        @keyframes fadeOut {
            0% {
                opacity: 1;
            }

            80% {
                opacity: 1;
            }

            100% {
                opacity: 0;
            }
        }

        /* CAPTCHA */
        .captcha {
            margin-top: 20px;
            padding: 15px;
            text-align: center;
            border: 2px dashed #39ff14;
            color: #39ff14;
            background-color: #121212;
            border-radius: 10px;
        }

        /* Footer */
        footer {
            text-align: center;
            color: #aaa;
            padding: 15px;
            background-color: #101010;
            font-size: 0.9rem;
        }

        /* Switch style */
        .switch-container {
            display: flex;
            align-items: center;
            margin-top: 20px;
        }

        .switch {
            position: relative;
            display: inline-block;
            width: 50px;
            height: 24px;
            margin-right: 10px;
        }

        .switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            transition: 0.4s;
            border-radius: 24px;
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 18px;
            width: 18px;
            left: 3px;
            bottom: 3px;
            background-color: white;
            transition: 0.4s;
            border-radius: 50%;
        }

input:checked + .slider {
    background-color: #ff0000;
}

        input:checked+.slider:before {
            transform: translateX(26px);
        }


        .form-container p {
            font-size: 1rem;
            color: #39ff14;
            margin: 0;
            margin-bottom: 10px;
            font-weight: bold;
            text-align: center;
            width: 100%;
        }

    
        .form-container .captcha-message {
            font-size: 1rem;
            color: #c5c6c7;
            margin-bottom: 10px;
            text-align: center;
        }

        /* Container du bouton More Infos */
        .more-info-container {
            display: flex;
            justify-content: flex-end;
            align-items: center;
            margin-bottom: 10px;
        }

        .more-info-btn {
            padding: 10px 20px;
            font-size: 1rem;
            color: #39ff14;
            background-color: #111;
            border: 2px solid #39ff14;
            text-transform: uppercase;
            cursor: pointer;
            transition: all 0.3s ease;
            border-radius: 5px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.5);
            position: relative;
            left: 54vh;
        }

        .more-info-btn:hover {
            background-color: #39ff14;
            color: #111;
            box-shadow: 0 6px 10px rgba(0, 255, 20, 0.5);
        }
        /* Effet Matrix en arrière-plan */
body::before {
    content: "";
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    pointer-events: none;
    z-index: -1;
    opacity: 0.1;
    background: linear-gradient(rgba(0, 255, 20, 0.1) 1px, transparent 1px),
                linear-gradient(90deg, rgba(0, 255, 20, 0.1) 1px, transparent 1px);
    background-size: 20px 20px;
    animation: matrix 20s linear infinite;
}

@keyframes matrix {
    0% { background-position: 0 0; }
    100% { background-position: 40px 40px; }
}


@keyframes scan {
    0% { transform: translateX(-100%); }
    100% { transform: translateX(1500px); }
}

/* Effet de glitch sur le titre */
.header h1 {
    position: relative;
    text-shadow: 
        0.05em 0 0 rgba(255, 0, 0, 0.75),
        -0.025em -0.05em 0 rgba(0, 255, 0, 0.75),
        0.025em 0.05em 0 rgba(0, 0, 255, 0.75);
    animation: glitch 500ms infinite;
}

@keyframes glitch {
    0% { text-shadow: 0.05em 0 0 rgba(255, 0, 0, 0.75),
        -0.05em -0.025em 0 rgba(0, 255, 0, 0.75),
        -0.025em 0.05em 0 rgba(0, 0, 255, 0.75); }
    15% { text-shadow: -0.05em -0.025em 0 rgba(255, 0, 0, 0.75),
        0.025em 0.025em 0 rgba(0, 255, 0, 0.75),
        -0.05em -0.05em 0 rgba(0, 0, 255, 0.75); }
    50% { text-shadow: 0.025em 0.05em 0 rgba(255, 0, 0, 0.75),
        0.05em 0 0 rgba(0, 255, 0, 0.75),
        0 -0.05em 0 rgba(0, 0, 255, 0.75); }
}


.btn {
    position: relative;
    overflow: hidden;
    box-shadow: 0 0 10px rgba(57, 255, 20, 0.3);
}

.btn::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(
        90deg,
        transparent,
        rgba(57, 255, 20, 0.2),
        transparent
    );
    animation: btnScan 3s linear infinite;
}

@keyframes btnScan {
    0% { left: -100%; }
    100% { left: 200%; }
}

/* Effet sur le tableau */
table {
    position: relative;
    box-shadow: 0 0 20px rgba(57, 255, 20, 0.1);
}

tr {
    position: relative;
    transition: all 0.3s ease;
}

tr:hover {
    background-color: rgba(57, 255, 20, 0.1) !important;
    transform: scale(1.01);
}


.notification {
    border-left: 5px solid #39ff14;
    background: rgba(0, 0, 0, 0.9);
    backdrop-filter: blur(10px);
    box-shadow: 0 0 15px rgba(57, 255, 20, 0.3);
    animation: notificationGlow 2s infinite alternate;
}

@keyframes notificationGlow {
    from { box-shadow: 0 0 15px rgba(57, 255, 20, 0.3); }
    to { box-shadow: 0 0 25px rgba(57, 255, 20, 0.5); }
}

/* Effet de terminal pour les inputs */
input[type="text"] {
    background: rgba(0, 0, 0, 0.8);
    border: 1px solid #39ff14;
    color: #39ff14;
    text-shadow: 0 0 5px rgba(57, 255, 20, 0.5);
    caret-color: #39ff14;
}

input[type="text"]:focus {
    outline: none;
    box-shadow: 0 0 15px rgba(57, 255, 20, 0.3);
    animation: inputPulse 1.5s infinite;
}

@keyframes inputPulse {
    0% { box-shadow: 0 0 15px rgba(57, 255, 20, 0.3); }
    50% { box-shadow: 0 0 25px rgba(57, 255, 20, 0.5); }
    100% { box-shadow: 0 0 15px rgba(57, 255, 20, 0.3); }
}
/* Dans votre balise <style> */
body {
    background-color: #000000 !important; /* Fond noir */
    position: relative;
    overflow-x: hidden;
}

/* Effet Matrix en rouge */
.matrix-background {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    z-index: -1;
}

/* Modifiez les couleurs en rouge */
.status-indicator, .btn, input[type="text"], h1, h2 {
    color: #ff0000 !important;
    border-color: #ff0000 !important;
}

.btn:hover {
    background-color: #ff0000 !important;
    color: #000 !important;
}

input[type="text"] {
    text-shadow: 0 0 5px rgba(255, 0, 0, 0.5) !important;
}

.notification {
    border-left: 5px solid #ff0000 !important;
    box-shadow: 0 0 15px rgba(255, 0, 0, 0.3) !important;
}
/* ... existing code ... */

.allowed-countries-input {
    margin-top: 20px;
    display: flex;
    gap: 10px;
    width: 100%;
}
/* ... existing code ... */

/* Formulaire */
.form-container {
    background-color: #1e1e1e;
    padding: 20px;
    border: 1px solid #333;
    border-radius: 10px;
    margin-bottom: 20px;
    display: flex;
    flex-wrap: wrap;
    justify-content: space-between;
    align-items: center;
}

/* Ajoutez les nouvelles règles ici, juste après le .form-container */
/* Nouveau style pour le conteneur de l'IP */
.form-container > input[type="text"]#ipAddress {
    width: 50%;
    flex: initial;
    margin-right: 10px;
}

/* Ajustement pour le bouton Set IP */
.form-container > button.btn:first-of-type {
    width: auto;
}

/* Style pour le groupe IP + bouton */
.form-container > input[type="text"]#ipAddress,
.form-container > button.btn:first-of-type {
    display: inline-block;
    vertical-align: middle;
}

/* Responsive */
@media screen and (max-width: 768px) {
    .form-container > input[type="text"]#ipAddress {
        width: 70%;
    }
}

@media screen and (max-width: 480px) {
    .form-container > input[type="text"]#ipAddress {
        width: 100%;
    }
}

/* Continuez avec les autres styles existants */
.form-container input[type="text"] {
    flex: 1;
    margin-right: 10px;
    padding: 10px;
    font-size: 1rem;
    border: 1px solid #333;
    background-color: #121212;
    color: #39ff14;
    border-radius: 5px;
}
/* ... rest of your existing code ... */

.country-tag {
    background: rgba(0, 0, 0, 0.8);
    border: 1px solid #ff0000;
    color: #ff0000;
    padding: 5px 10px;
    border-radius: 5px;
    display: flex;
    align-items: center;
    gap: 10px;
}

.country-tag .remove {
    cursor: pointer;
    font-size: 14px;
    padding: 0 5px;
}

.country-tag .remove:hover {
    color: white;
}
/* Style pour le bouton Show Options */
.show-options-btn {
    margin-bottom: 20px;
    background-color: #1e1e1e;
    border: 1px solid #ff0000;
    color: #ff0000;
    padding: 10px 20px;
    border-radius: 5px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.show-options-btn:hover {
    background-color: #ff0000;
    color: #000;
}

/* Styles pour l'animation du formulaire */
.form-container {
    transition: all 0.5s ease;
    max-height: 1000px; /* Ajustez selon la hauteur maximale de votre formulaire */
    opacity: 1;
    transform: translateY(0);
    overflow: hidden;
}

.form-container.hidden {
    max-height: 0;
    opacity: 0;
    transform: translateY(-20px);
    margin: 0;
    padding: 0;
    border: none;
}

@import url('https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css');

/* Style pour le bouton actif */
.menu-btn.active {
    background: #ff0000;
    color: #000;
}

.menu-toggle {
    position: fixed;
    top: 20px;
    right: 20px;
    background: rgba(0, 0, 0, 0.8);
    border: 1px solid #ff0000;
    border-radius: 8px;
    width: 50px;
    height: 50px;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    z-index: 1000;
    transition: all 0.3s ease;
    overflow: hidden;
}

.menu-toggle svg {
    width: 24px;
    height: 24px;
    transition: transform 0.3s ease;
}

.menu-toggle svg path {
    stroke: #ff0000;
    stroke-width: 2;
    stroke-linecap: round;
    transition: all 0.3s ease;
}

.menu-toggle:hover {
    background: rgba(255, 0, 0, 0.1);
    box-shadow: 0 0 15px rgba(255, 0, 0, 0.3);
}

.menu-toggle:hover svg {
    transform: scale(1.1);
}

.menu-toggle:hover svg path {
    stroke-dasharray: 15;
    stroke-dashoffset: 20;
    animation: dash 1.5s linear infinite;
}

@keyframes dash {
    to {
        stroke-dashoffset: 0;
    }
}
/* Header du menu */
.menu-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0 20px 20px;
    border-bottom: 1px solid rgba(255, 0, 0, 0.3);
    margin-bottom: 20px;
}

.menu-header span {
    color: #ff0000;
    font-size: 20px;
    font-weight: bold;
}

.close-menu {
    background: none;
    border: none;
    color: #ff0000;
    font-size: 20px;
    cursor: pointer;
    padding: 5px;
}

/* Animation du menu */
@keyframes slideIn {
    from {
        transform: translateX(100%);
        opacity: 0;
    }
    to {
        transform: translateX(0);
        opacity: 1;
    }
}

.nav-menu.active {
    animation: slideIn 0.3s ease forwards;
}

/* Classes pour cacher/montrer */
.hidden {
    display: none;
}

.menu-overlay.hidden {
    display: none;
}
.nav-menu.hidden {
    display: none;
}
/* Style du menu latéral et des boutons */
.nav-menu {
    position: fixed;
    top: 0;
    right: -300px;
    width: 300px;
    height: 100vh;
    background: rgba(0, 0, 0, 0.95);
    border-left: 1px solid #ff0000;
    padding: 20px;
    transition: all 0.3s ease;
    z-index: 1001;
    visibility: hidden;
}

.menu-btn i {
    width: 20px;
    text-align: center;
    font-size: 16px;
}
.nav-menu {
    position: fixed;
    top: 0;
    right: -300px;
    width: 300px;
    height: 100vh;
    background: rgba(0, 0, 0, 0.95);
    border-left: 1px solid #ff0000;
    padding: 20px;
    transition: all 0.3s ease;
    z-index: 1001;
    visibility: hidden;
}

.nav-menu.active {
    right: 0;
    visibility: visible;
}

.menu-container {
    display: flex;
    flex-direction: column;
    gap: 15px;
    padding: 0 20px;
}

.menu-btn {
    background: transparent;
    color: #ff0000;
    border: 1px solid #ff0000;
    border-radius: 5px;
    padding: 15px;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 10px;
    width: 100%;
    text-align: left;
    font-size: 14px;
}
/* Supprimer les doublons et garder uniquement cette version */
.menu-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.7);
    z-index: 1000;
    opacity: 0;
    visibility: hidden;
    transition: all 0.3s ease;
}

.menu-overlay.active {
    opacity: 1;
    visibility: visible;
}
.menu-btn:hover {
    background: #ff0000;
    color: #000;
    transform: translateX(5px);
    box-shadow: 0 0 15px rgba(255, 0, 0, 0.3);
}
/* Style pour le bouton de fermeture */
.close-menu {
    position: absolute;
    top: 15px;
    right: 15px;
    width: 30px;
    height: 30px;
    background: transparent;
    border: 2px solid #ff0000;
    border-radius: 50%;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s ease;
    z-index: 1002;
}

.close-menu:hover {
    background: #ff0000;
    transform: rotate(90deg);
}

.close-menu svg {
    width: 14px;
    height: 14px;
    fill: none;
    stroke: #ff0000;
    stroke-width: 2;
    transition: all 0.3s ease;
}

.close-menu:hover svg {
    stroke: #000;
}

/* Style pour les icônes du menu */
.menu-btn svg {
    width: 20px;
    height: 20px;
    margin-right: 10px;
    fill: none;
    stroke: #ff0000;
    stroke-width: 2;
    transition: all 0.3s ease;
}

.menu-btn:hover svg {
    stroke: #000;
}
.delete-log-btn {
    background: transparent;
    border: none;
    cursor: pointer;
    padding: 5px;
    transition: all 0.3s ease;
    border-radius: 50%;
}

.delete-log-btn:hover {
    background: rgba(255, 0, 0, 0.1);
    transform: scale(1.1);
}

.delete-log-btn:hover .delete-icon path {
    stroke: #ff3333;
    stroke-width: 2.5;
}

.delete-icon {
    transition: all 0.3s ease;
}
/* ... existing code ... */
@keyframes sliceAndFade {
    0% {
        clip-path: polygon(0 0, 100% 0, 100% 100%, 0 100%);
        transform: translateX(0);
        opacity: 1;
    }
    30% {
        clip-path: polygon(0 0, 100% 0, 100% 100%, 0 100%);
        transform: translateX(5px);
        opacity: 1;
        background: rgba(255, 0, 0, 0.05);
    }
    40% {
        clip-path: polygon(0 0, 50% 0, 50% 100%, 0 100%);
        background: rgba(255, 0, 0, 0.1);
    }
    45% {
        clip-path: polygon(50% 0, 100% 0, 100% 100%, 50% 100%);
    }
    50% {
        clip-path: polygon(0 0, 49% 0, 49% 100%, 0 100%);
        transform: translateX(-30px);
        opacity: 0.9;
    }
    75% {
        clip-path: polygon(51% 0, 100% 0, 100% 100%, 51% 100%);
        transform: translateX(30px);
        opacity: 0.5;
    }
    100% {
        clip-path: polygon(0 0, 49% 0, 49% 100%, 0 100%),
                         polygon(51% 0, 100% 0, 100% 100%, 51% 100%);
        transform: translateX(-50px);
        opacity: 0;
    }
}

.slice-delete {
    position: relative;
    animation: sliceAndFade 1s cubic-bezier(0.65, 0, 0.35, 1) forwards;
}

.slice-delete::before {
    content: '';
    position: absolute;
    top: 0;
    left: 50%;
    width: 2px;
    height: 100%;
    background: linear-gradient(to bottom, 
        transparent, 
        rgba(255, 0, 0, 0.8),
        transparent
    );
    transform: translateX(-50%);
    opacity: 0;
    animation: sliceLine 0.3s ease-in forwards;
    animation-delay: 0.2s;
}

@keyframes sliceLine {
    0% {
        opacity: 0;
        transform: translateX(-50%) scaleY(0);
    }
    50% {
        opacity: 1;
        transform: translateX(-50%) scaleY(1);
    }
    100% {
        opacity: 0;
        transform: translateX(-50%) scaleY(0);
    }
}

    </style>
</head>

<body>

<canvas id="matrix-background" class="matrix-background"></canvas>

<script>
const canvas = document.getElementById('matrix-background');
const ctx = canvas.getContext('2d');


function resizeCanvas() {
    canvas.width = window.innerWidth;
    canvas.height = window.innerHeight;
}
resizeCanvas();
window.addEventListener('resize', resizeCanvas);


const chars = '01'.split('');
const fontSize = 14;
const columns = canvas.width / fontSize;
const drops = [];


for (let i = 0; i < columns; i++) {
    drops[i] = Math.floor(Math.random() * canvas.height/fontSize);
}


function draw() {
    ctx.fillStyle = 'rgba(0, 0, 0, 0.05)';
    ctx.fillRect(0, 0, canvas.width, canvas.height);

    ctx.fillStyle = '#ff0000'; 
    ctx.font = fontSize + 'px monospace';

    for (let i = 0; i < drops.length; i++) {
        const text = chars[Math.floor(Math.random() * chars.length)];
        ctx.fillText(text, i * fontSize, drops[i] * fontSize);

        if (drops[i] * fontSize > canvas.height && Math.random() > 0.975) {
            drops[i] = 0;
        }
        drops[i]++;
    }
}


setInterval(draw, 35);


document.querySelectorAll('.btn, input[type="text"]').forEach(element => {
    element.addEventListener('mouseover', function() {
        this.style.textShadow = '0 0 10px #ff0000';
        this.style.boxShadow = '0 0 15px rgba(255, 0, 0, 0.5)';
    });

    element.addEventListener('mouseout', function() {
        this.style.textShadow = 'none';
        this.style.boxShadow = 'none';
    });
});
</script>
    <div class="header">
        <h1>Corleone Control Panel</h1>
        <div class="status"></div>
    </div>

    <div class="container-fluid">
        <h2>Visitor Logs</h2>
        <table id="visitorTable">
            <thead>
                <tr>
                    <th>IP Address</th>
                    <th>Date</th>
                    <th>ISP</th>
                    <th>Country</th>
                    <th>DeviceINFOS</th>
                    <th>Status</th>
                    <th>Navigateur</th>
                    <th>os</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <!-- Exemple de données -->

<tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:19b:4300:5270:29aa:37a9:f375:520b</td><td>2025-11-16 23:06:01</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.115.134.131</td><td>2025-11-16 23:06:13</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.115.134.131</td><td>2025-11-16 23:06:47</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/eg.png' alt='Egypt'> 196.129.79.163</td><td>2025-11-16 23:09:20</td><td>Vodafone Data</td><td>Egypt</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:444:881:e080:bcd5:2af1:851c:163c</td><td>2025-11-16 23:29:37</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2603:8000:8500:1cf3:5967:7e61:1f8a:562d</td><td>2025-11-16 23:41:51</td><td>Charter Communications Inc</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.0.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:18e:d081:27e0:7c1d:3d93:8503:2a8</td><td>2025-11-16 23:46:07</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.115.134.131</td><td>2025-11-16 23:57:18</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:348:600:4660:e187:1838:af13:50f3</td><td>2025-11-17 00:13:07</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>iPhone</td><td>Safari 26.0.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:406:8100:d30:f57f:decf:6987:8716</td><td>2025-11-17 00:32:26</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:406:8100:d30:f57f:decf:6987:8716</td><td>2025-11-17 00:44:29</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:18c:8900:45c0:7c52:88b5:16a2:e8aa</td><td>2025-11-17 02:02:09</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 18.6</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:640:8e80:d70:e1cc:edb1:8bbd:67f9</td><td>2025-11-17 03:23:22</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 26.0.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:985:d83:4710:18a9:4c8f:bb95:fac3</td><td>2025-11-17 14:03:05</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 18.3.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:985:d83:4710:18a9:4c8f:bb95:fac3</td><td>2025-11-17 14:06:21</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 18.3.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:985:d83:4710:18a9:4c8f:bb95:fac3</td><td>2025-11-17 14:07:32</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Macintosh</td><td>Safari 18.3.1</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 164.52.253.226</td><td>2025-11-17 16:21:20</td><td>DQE Communications LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 131.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/us.png' alt='United States'> 2601:58b:580:7450:7935:51b:439:953b</td><td>2025-11-17 16:28:42</td><td>Comcast Cable Communications, LLC</td><td>United States</td><td><span class='status-device'>💻 Desktop Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Windows</td><td>Chrome 142.0.0.0</td></tr><tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/ma.png' alt='Morocco'> 196.115.134.131</td><td>2025-11-17 16:55:17</td><td>MEDITELECOM</td><td>Morocco</td><td><span class='status-device'>📱 Mobile Device</span></td><td><span class='status-clean'>✅ CLEAN</span></td><td>Android</td><td>Chrome 142.0.0.0</td></tr></tbody>
        </table>

<div class="menu-toggle" onclick="toggleMenu()">
    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path class="line line-1" d="M3 6H21" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
        <path class="line line-2" d="M3 12H21" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
        <path class="line line-3" d="M3 18H21" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
    </svg>
</div>

<!-- Menu latéral -->
<nav class="nav-menu">
    <div class="menu-header">
        <span>Menu</span>
        <button class="close-menu" onclick="toggleMenu()">
            <i class="fas fa-times"></i>
        </button>
    </div>
    <div class="menu-container">
        <button class="menu-btn" onclick="showBanForm()">
            <i class="fas fa-ban"></i>
            Ban IP
        </button>
        <button class="menu-btn" onclick="showAllowedCountries()">
            <i class="fas fa-globe"></i>
            Allowed Countries
        </button>
        <button class="menu-btn" onclick="showBannedIPs()">
            <i class="fas fa-list"></i>
            Show Banned IPs
        </button>
        <button class="menu-btn" onclick="clearLogs()">
            <i class="fas fa-trash-alt"></i>
            Clear Logs
        </button>
        <button class="menu-btn" onclick="toggleIframe()">
            <i class="fas fa-chart-line"></i>
            Status en temps réel
        </button>
    </div>
</nav>

<div class="menu-overlay" onclick="toggleMenu()"></div>

        <div id="captchaContainer"></div>
    </div>

    <div class="notifications" id="notifications"></div>

    <footer>
        <p>Powered by @corleone776 | 2025</p>
    </footer>

    <script>
        let currentIp = "";

        function setIpAction() {
            const ipField = document.getElementById("ipAddress");
            currentIp = ipField.value;
            if (currentIp) {
                showNotification(`IP ${currentIp} définie avec succès ✅ .`);
                ipField.value = ""; 
            } else {
                showNotification("Veuillez entrer une adresse IP valide ❌.", "error");
            }
        }

        function performAction(action) {
            if (!currentIp) {
                showNotification("Veuillez d'abord définir une adresse IP ❌ .", "error");
                return;
            }

            showNotification(`Action ${action.toUpperCase()} exécutée avec succès sur l'IP ${currentIp}.✅`);
        }
function clearLogs() {
   toggleMenu();
    fetch('status/clear-logs.php')
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                const tableBody = document.querySelector("#visitorTable tbody");
                tableBody.innerHTML = "";
                showNotification("Tous les logs ont été effacés avec succès ✅.");
            } else {
                showNotification("Erreur lors de la suppression des logs ❌.", "error");
            }
        })
        .catch(error => {
            showNotification("Erreur de connexion au serveur ❌.", "error");
        });
}

        function banIp() {
          toggleMenu();
            if (!currentIp) {
                showNotification("Veuillez d'abord définir une adresse IP ❌.", "error");
                return;
            }

            
            fetch('../panel/banip/ban-ip.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({ ip: currentIp })
            })
            .then(response => response.json())
            .then(data => {
                if (data.status === 'success') {
                    showNotification(`IP ${currentIp} a été bloquée avec succès ✅.`);
                } else {
                    showNotification(data.message, 'error');
                }
            })
            .catch(error => {
                showNotification("Erreur de connexion au serveur ❌.", "error");
            });
        }

        function showNotification(message, type = "success") {
            const notification = document.createElement("div");
            notification.className = `notification ${type}`;
            notificatiotch(error => {
                showNotification("Erreur de connexion au serveur ❌.", "error");
            });
        }

        function showNotification(message, type = "success") {
            const notification = document.createElement("div");
            notification.className = `notification ${type}`;
            notification.textContent = message;

            const notificationsContainer = document.getElementById("notifications");
            notificationsContainer.appendChild(notification);

            setTimeout(() => {
                notificationsContainer.removeChild(notification);
            }, 5000);
        }

        function toggleSwitch() {
            const switchElement = document.getElementById('dynamicSwitch');
            const statusText = document.getElementById('switchStatus');
            const captchaMessage = document.getElementById('captchaMessage');
            if (switchElement.checked) {
                statusText.textContent = "Active";
                captchaMessage.textContent = "Captcha activé !";
                showNotification("Switch activated.");
            } else {
                statusText.textContent = "Inactive (activer ou desactiver le captcha)";
                captchaMessage.textContent = "activer ou desactiver le captcha";
                showNotification("Switch deactivated.");
            }
        }
    </script>
<script>
    function toggleIframe() {
    toggleMenu();
        const existingIframeContainer = document.getElementById("iframeContainer");

       
        if (existingIframeContainer) {
            existingIframeContainer.remove();
            showNotification("Affichage temps réel fermé ✅.");
        } else {

            const iframe = document.createElement("iframe");
            iframe.id = "realtimeIframe";
            iframe.src = "status/onlinesystem/status.html";
            iframe.style.position = "fixed";
            iframe.style.top = "50%";
            iframe.style.left = "50%";
            iframe.style.transform = "translate(-50%, -50%)";
            iframe.style.width = "80%";
            iframe.style.height = "80%";
            iframe.style.border = "2px solid #ff0000";
            iframe.style.borderRadius = "10px";
            iframe.style.backgroundColor = "#121212";
            iframe.style.zIndex = "1000";
            iframe.style.boxShadow = "0 4px 6px rgba(0, 0, 0, 0.8)";

            // Bouton de fermeture
            const closeButton = document.createElement("button");
            closeButton.textContent = "✖";
            closeButton.style.position = "absolute";
            closeButton.style.top = "10px";
            closeButton.style.right = "10px";
            closeButton.style.backgroundColor = "#ff4d4d";
            closeButton.style.color = "#fff";
            closeButton.style.border = "none";
            closeButton.style.borderRadius = "50%";
            closeButton.style.padding = "5px 10px";
            closeButton.style.cursor = "pointer";
            closeButton.style.zIndex = "1001";
            closeButton.onclick = function() {
                const container = document.getElementById("iframeContainer");
                if (container) {
                    container.remove();
                }
                showNotification("Affichage temps réel fermé ✅.");
            };

            // Conteneur pour iframe et bouton
            const iframeContainer = document.createElement("div");
            iframeContainer.id = "iframeContainer";
            iframeContainer.style.position = "fixed";
            iframeContainer.style.top = "0";
            iframeContainer.style.left = "0";
            iframeContainer.style.width = "100%";
            iframeContainer.style.height = "100%";
            iframeContainer.style.backgroundColor = "rgba(0, 0, 0, 0.8)";
            iframeContainer.style.zIndex = "999";
            iframeContainer.appendChild(iframe);
            iframeContainer.appendChild(closeButton);

            document.body.appendChild(iframeContainer);
            showNotification("Affichage temps réel activé ✅.");
        }
    }


    function showNotification(message, type = "success") {
        const notification = document.createElement("div");
        notification.className = `notification ${type}`;
        notification.textContent = message;

        const notificationsContainer = document.getElementById("notifications") || createNotificationsContainer();
        notificationsContainer.appendChild(notification);

        setTimeout(() => {
            notification.remove();
        }, 5000);
    }


    function createNotificationsContainer() {
        const container = document.createElement("div");
        container.id = "notifications";
        container.style.position = "fixed";
        container.style.top = "20px";
        container.style.right = "20px";
        container.style.zIndex = "10000";
        container.style.display = "flex";
        container.style.flexDirection = "column";
        container.style.gap = "10px";
        document.body.appendChild(container);
        return container;
    }
</script>
<script>
function showBannedIPs() {
 toggleMenu();
    const iframeContainer = document.createElement("div");
    iframeContainer.id = "bannedIPsContainer";
    iframeContainer.style.position = "fixed";
    iframeContainer.style.top = "50%";
    iframeContainer.style.left = "50%";
    iframeContainer.style.transform = "translate(-50%, -50%)";
    iframeContainer.style.width = "80%";
    iframeContainer.style.maxWidth = "600px";
    iframeContainer.style.backgroundColor = "rgba(0, 0, 0, 0.95)";
    iframeContainer.style.border = "1px solid #ff0000";
    iframeContainer.style.borderRadius = "10px";
    iframeContainer.style.padding = "20px";
    iframeContainer.style.zIndex = "1000";
    iframeContainer.style.boxShadow = "0 0 20px rgba(255, 0, 0, 0.3)";

    // Header avec titre et bouton de fermeture
    const header = document.createElement("div");
    header.style.display = "flex";
    header.style.justifyContent = "space-between";
    header.style.alignItems = "center";
    header.style.marginBottom = "20px";

    const title = document.createElement("h2");
    title.textContent = "Banned IPs";
    title.style.color = "#ff0000";
    title.style.margin = "0";

    const closeButton = document.createElement("button");
    closeButton.textContent = "✖";
    closeButton.style.backgroundColor = "#ff0000";
    closeButton.style.color = "#fff";
    closeButton.style.border = "none";
    closeButton.style.borderRadius = "50%";
    closeButton.style.padding = "5px 10px";
    closeButton.style.cursor = "pointer";
    closeButton.onclick = () => iframeContainer.remove();

    header.appendChild(title);
    header.appendChild(closeButton);
    iframeContainer.appendChild(header);

    
const searchContainer = document.createElement("div");
searchContainer.style.marginBottom = "20px";
searchContainer.style.position = "relative";
searchContainer.style.width = "100%";
searchContainer.style.padding = "0 5px";

    const searchIcon = document.createElement("span");
    searchIcon.innerHTML = "🔍";
    searchIcon.style.position = "absolute";
    searchIcon.style.left = "10px";
    searchIcon.style.top = "50%";
    searchIcon.style.transform = "translateY(-50%)";
    searchIcon.style.color = "#ff0000";
    searchIcon.style.fontSize = "16px";

const searchInput = document.createElement("input");
searchInput.type = "text";
searchInput.placeholder = "Search IP...";
searchInput.style.width = "calc(100% - 10px)"; // Soustrait le padding pour un alignement parfait
searchInput.style.padding = "10px 35px";
searchInput.style.backgroundColor = "rgba(0, 0, 0, 0.8)";
searchInput.style.border = "1px solid #ff0000";
searchInput.style.borderRadius = "5px";
searchInput.style.color = "#ff0000";
searchInput.style.fontSize = "14px";
searchInput.style.outline = "none";
searchInput.style.boxSizing = "border-box";

    // Animation de focus pour la barre de recherche
    searchInput.style.transition = "all 0.3s ease";
    searchInput.addEventListener('focus', () => {
        searchInput.style.boxShadow = "0 0 15px rgba(255, 0, 0, 0.3)";
    });
    searchInput.addEventListener('blur', () => {
        searchInput.style.boxShadow = "none";
    });

    searchContainer.appendChild(searchIcon);
    searchContainer.appendChild(searchInput);
    iframeContainer.appendChild(searchContainer);

const ipList = document.createElement("div");
ipList.style.maxHeight = "400px";
ipList.style.overflowY = "auto";
ipList.style.marginBottom = "20px";
ipList.style.width = "100%"; // Assure que la liste prend toute la largeur
ipList.style.boxSizing = "border-box"; // Inclut le padding dans la largeur
ipList.style.padding = "0 5px"; 

    // Stylisation de la scrollbar
    ipList.style.scrollbarWidth = "thin";
    ipList.style.scrollbarColor = "#ff0000 #1a1a1a";

    // Charger les IPs bannies
    fetch('unban-ip/get-banned-ips.php')
        .then(response => response.json())
        .then(data => {
            if (data.ips && data.ips.length > 0) {
                const createIPItem = (ip) => {
                    const ipItem = document.createElement("div");
                    ipItem.style.display = "flex";
                    ipItem.style.justifyContent = "space-between";
                    ipItem.style.alignItems = "center";
                    ipItem.style.padding = "10px";
                    ipItem.style.borderBottom = "1px solid #333";
                    ipItem.style.color = "#ff0000";
                    ipItem.style.transition = "all 0.3s ease";

                    const ipText = document.createElement("span");
                    ipText.textContent = ip;

                    const removeBtn = document.createElement("button");
                    removeBtn.textContent = "Unban";
                    removeBtn.className = "btn";
                    removeBtn.style.padding = "5px 10px";
                    removeBtn.style.fontSize = "0.8em";
                    removeBtn.style.backgroundColor = "transparent";
                    removeBtn.style.border = "1px solid #ff0000";
                    removeBtn.style.color = "#ff0000";
                    removeBtn.style.cursor = "pointer";
                    removeBtn.style.transition = "all 0.3s ease";

                    removeBtn.addEventListener('mouseover', () => {
                        removeBtn.style.backgroundColor = "#ff0000";
                        removeBtn.style.color = "#000";
                    });

                    removeBtn.addEventListener('mouseout', () => {
                        removeBtn.style.backgroundColor = "transparent";
                        removeBtn.style.color = "#ff0000";
                    });

                    removeBtn.onclick = () => unbanIP(ip, ipItem);

                    ipItem.appendChild(ipText);
                    ipItem.appendChild(removeBtn);
                    return ipItem;
                };

                // Fonction de filtrage
                const filterIPs = (searchTerm) => {
                    const items = ipList.children;
                    let hasVisibleItems = false;

                    Array.from(items).forEach(item => {
                        const ipText = item.firstChild.textContent.toLowerCase();
                        const matches = ipText.includes(searchTerm.toLowerCase());
                        item.style.display = matches ? "flex" : "none";
                        if (matches) hasVisibleItems = true;
                    });

                    // Afficher un message si aucun résultat
                    const noResults = ipList.querySelector('.no-results');
                    if (!hasVisibleItems) {
                        if (!noResults) {
                            const noResultsMsg = document.createElement("div");
                            noResultsMsg.className = 'no-results';
                            noResultsMsg.textContent = "No matching IPs found";
                            noResultsMsg.style.color = "#666";
                            noResultsMsg.style.textAlign = "center";
                            noResultsMsg.style.padding = "20px";
                            ipList.appendChild(noResultsMsg);
                        }
                    } else if (noResults) {
                        noResults.remove();
                    }
                };

                // Ajouter les IPs et configurer la recherche
                data.ips.forEach(ip => {
                    ipList.appendChild(createIPItem(ip));
                });

                searchInput.addEventListener('input', (e) => {
                    filterIPs(e.target.value);
                });

            } else {
                const noIPs = document.createElement("div");
                noIPs.textContent = "No banned IPs";
                noIPs.style.color = "#666";
                noIPs.style.textAlign = "center";
                noIPs.style.padding = "20px";
                ipList.appendChild(noIPs);
            }
        })
        .catch(error => {
            showNotification("Error loading banned IPs ❌", "error");
        });

    iframeContainer.appendChild(ipList);
    document.body.appendChild(iframeContainer);
}

function unbanIP(ip, element) {
    fetch('unban-ip/unban-ip.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ ip: ip })
    })
    .then(response => response.json())
    .then(data => {
        if (data.status === 'success') {
            element.remove();
            showNotification(`IP ${ip} has been unbanned ✅`);
        } else {
            showNotification("Error unbanning IP ❌", "error");
        }
    })
    .catch(error => {
        showNotification("Server error ❌", "error");
    });
}
</script>
<script>
let allowedCountries = new Set();

// Fonction pour charger les pays existants
function loadExistingCountries() {
    fetch('countryallowed/get-countries.php')
        .then(response => response.json())
        .then(data => {
            if (data.countries) {
                allowedCountries = new Set(data.countries);
                updateCountriesList();
            }
        })
        .catch(error => {
            console.log("Erreur lors du chargement des pays", error);
        });
}

// Fonction pour mettre à jour l'affichage de la liste
function updateCountriesList() {
    const container = document.getElementById('allowedCountriesList');
    container.innerHTML = '';
    
    allowedCountries.forEach(country => {
        const tag = document.createElement('div');
        tag.className = 'country-tag';
        tag.innerHTML = `
            ${country.toUpperCase()}
            <span class="remove" onclick="removeCountry('${country}')">✕</span>
        `;
        container.appendChild(tag);
    });
}

function addAllowedCountry(customCountryCode = null) {
    // Utiliser soit le code pays personnalisé, soit celui de l'input
    const countryCode = customCountryCode || document.getElementById('countryCode').value.trim().toLowerCase();
    
    if (!countryCode) return;

    if (allowedCountries.has(countryCode)) {
        showNotification(`Le pays ${countryCode.toUpperCase()} est déjà dans la liste ❌`, "error");
        return;
    }
    
    fetch('countryallowed/update-countries.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ 
            action: 'add',
            countryCode: countryCode 
        })
    })
    .then(response => {
        if (!response.ok) {
            throw new Error('Erreur réseau');
        }
        return response.json();
    })
    .then(data => {
        if (data.status === 'success') {
            allowedCountries.add(countryCode);
            updateCountriesList();
            // Si on utilise l'input original, le vider
            if (!customCountryCode) {
                document.getElementById('countryCode').value = '';
            }
            showNotification(`Pays ${countryCode.toUpperCase()} ajouté avec succès ✅`);
        } else {
            throw new Error(data.message || 'Erreur lors de l\'ajout du pays');
        }
    })
    .catch(error => {
        loadExistingCountries();
        showNotification("Mise à jour de la liste des pays ✅");
    });
}


document.addEventListener('DOMContentLoaded', loadExistingCountries);
function toggleOptions() {
 toggleMenu();
    const formContainer = document.querySelector('.form-container');
    const button = document.querySelector('.show-options-btn');
    
    if (formContainer.classList.contains('hidden')) {
        formContainer.classList.remove('hidden');
        button.textContent = 'Hide Options';
        // Animation Matrix plus intense pendant l'ouverture
        document.querySelector('.matrix-background').style.opacity = '0.2';
        setTimeout(() => {
            document.querySelector('.matrix-background').style.opacity = '0.1';
        }, 500);
    } else {
        formContainer.classList.add('hidden');
        button.textContent = 'Show Options';
        // Flash Matrix pendant la fermeture
        document.querySelector('.matrix-background').style.opacity = '0.2';
        setTimeout(() => {
            document.querySelector('.matrix-background').style.opacity = '0.1';
        }, 500);
    }
}

// Cacher le formulaire au chargement de la page
document.addEventListener('DOMContentLoaded', function() {
    const formContainer = document.querySelector('.form-container');
    formContainer.classList.add('hidden');
});
function toggleActiveButton(clickedButton) {
    document.querySelectorAll('.menu-btn').forEach(btn => {
        btn.classList.remove('active');
    });
    
    clickedButton.classList.add('active');
}
function toggleMenu() {
    const menu = document.querySelector('.nav-menu');
    const overlay = document.querySelector('.menu-overlay');
    
    if (menu.classList.contains('active')) {
        // Fermeture du menu
        menu.style.right = '-300px';
        overlay.style.opacity = '0';
        
        requestAnimationFrame(() => {
            setTimeout(() => {
                menu.style.visibility = 'hidden';
                overlay.style.visibility = 'hidden';
                menu.classList.remove('active');
                overlay.classList.remove('active');
            }, 300);
        });
    } else {
        // Ouverture du menu
        menu.style.visibility = 'visible';
        overlay.style.visibility = 'visible';
        
        requestAnimationFrame(() => {
            menu.style.right = '0';
            overlay.style.opacity = '1';
            menu.classList.add('active');
            overlay.classList.add('active');
        });
    }
}

// Initialisation au chargement
document.addEventListener('DOMContentLoaded', function() {
    const menu = document.querySelector('.nav-menu');
    const overlay = document.querySelector('.menu-overlay');
    
    // État initial
    menu.style.right = '-300px';
    menu.style.visibility = 'hidden';
    overlay.style.visibility = 'hidden';
    overlay.style.opacity = '0';
    
    menu.classList.remove('active');
    overlay.classList.remove('active');
});

// Fermeture avec la touche Escape
document.addEventListener('keydown', (e) => {
    if (e.key === 'Escape') {
        const menu = document.querySelector('.nav-menu');
        if (menu.classList.contains('active')) {
            toggleMenu();
        }
    }
});
function showBanForm() {
    toggleMenu();
    
    const formContainer = document.createElement("div");
    formContainer.id = "banFormContainer";
    formContainer.style.position = "fixed";
    formContainer.style.top = "50%";
    formContainer.style.left = "50%";
    formContainer.style.transform = "translate(-50%, -50%)";
    formContainer.style.width = "80%";
    formContainer.style.maxWidth = "500px";
    formContainer.style.backgroundColor = "rgba(0, 0, 0, 0.95)";
    formContainer.style.border = "1px solid #ff0000";
    formContainer.style.borderRadius = "10px";
    formContainer.style.padding = "20px";
    formContainer.style.zIndex = "1000";
    formContainer.style.boxShadow = "0 0 20px rgba(255, 0, 0, 0.3)";

    // Header
    const header = document.createElement("div");
    header.style.display = "flex";
    header.style.justifyContent = "space-between";
    header.style.alignItems = "center";
    header.style.marginBottom = "20px";
    header.style.borderBottom = "1px solid rgba(255, 0, 0, 0.3)";
    header.style.paddingBottom = "10px";

    const title = document.createElement("h2");
    title.textContent = "Ban IP Address";
    title.style.color = "#ff0000";
    title.style.margin = "0";

    const closeButton = document.createElement("button");
    closeButton.innerHTML = "✖";
    closeButton.style.backgroundColor = "#ff0000";
    closeButton.style.color = "#fff";
    closeButton.style.border = "none";
    closeButton.style.borderRadius = "50%";
    closeButton.style.padding = "5px 10px";
    closeButton.style.cursor = "pointer";
    closeButton.onclick = () => formContainer.remove();

    header.appendChild(title);
    header.appendChild(closeButton);
    formContainer.appendChild(header);

    // Formulaire
    const input = document.createElement("input");
    input.type = "text";
    input.placeholder = "Enter IP address";
    input.style.width = "100%";
    input.style.padding = "10px";
    input.style.marginBottom = "15px";
    input.style.backgroundColor = "rgba(0, 0, 0, 0.8)";
    input.style.border = "1px solid #ff0000";
    input.style.borderRadius = "5px";
    input.style.color = "#ff0000";
    input.style.outline = "none";

    const banButton = document.createElement("button");
    banButton.textContent = "Ban IP";
    banButton.className = "menu-btn";
    banButton.style.width = "100%";
    banButton.onclick = () => {
        const ip = input.value.trim();
        if (ip) {
            currentIp = ip;
            banIp();
            formContainer.remove();
        } else {
            showNotification("Veuillez entrer une adresse IP valide ❌", "error");
        }
    };

    formContainer.appendChild(input);
    formContainer.appendChild(banButton);
    document.body.appendChild(formContainer);
}

function showAllowedCountries() {
    toggleMenu();
    
    const container = document.createElement("div");
    container.id = "allowedCountriesContainer";
    container.style.position = "fixed";
    container.style.top = "50%";
    container.style.left = "50%";
    container.style.transform = "translate(-50%, -50%)";
    container.style.width = "80%";
    container.style.maxWidth = "600px";
    container.style.backgroundColor = "rgba(0, 0, 0, 0.95)";
    container.style.border = "1px solid #ff0000";
    container.style.borderRadius = "10px";
    container.style.padding = "20px";
    container.style.zIndex = "1000";
    container.style.boxShadow = "0 0 20px rgba(255, 0, 0, 0.3)";

    // Header
    const header = document.createElement("div");
    header.style.display = "flex";
    header.style.justifyContent = "space-between";
    header.style.alignItems = "center";
    header.style.marginBottom = "20px";
    header.style.borderBottom = "1px solid rgba(255, 0, 0, 0.3)";
    header.style.paddingBottom = "10px";

    const title = document.createElement("h2");
    title.textContent = "Allowed Countries";
    title.style.color = "#ff0000";
    title.style.margin = "0";

    const closeButton = document.createElement("button");
    closeButton.innerHTML = "✖";
    closeButton.style.backgroundColor = "#ff0000";
    closeButton.style.color = "#fff";
    closeButton.style.border = "none";
    closeButton.style.borderRadius = "50%";
    closeButton.style.padding = "5px 10px";
    closeButton.style.cursor = "pointer";
    closeButton.onclick = () => container.remove();

    header.appendChild(title);
    header.appendChild(closeButton);
    container.appendChild(header);

    // Container pour les switches
    const switchesContainer = document.createElement("div");
    switchesContainer.style.marginBottom = "20px";
    switchesContainer.style.padding = "15px";
    switchesContainer.style.border = "1px solid rgba(255, 0, 0, 0.3)";
    switchesContainer.style.borderRadius = "5px";
    switchesContainer.style.display = "flex";
    switchesContainer.style.flexDirection = "column";
    switchesContainer.style.gap = "15px";

    // Switch pour la vérification des pays
    const countryCheckContainer = document.createElement("div");
    countryCheckContainer.style.display = "flex";
    countryCheckContainer.style.alignItems = "center";
    countryCheckContainer.style.justifyContent = "space-between";

    const countryLabel = document.createElement("span");
    countryLabel.textContent = "check country";
    countryLabel.style.color = "#ff0000";

    const countrySwitch = document.createElement("label");
    countrySwitch.className = "switch";
    countrySwitch.innerHTML = `
        <input type="checkbox" id="countryCheck">
        <span class="slider"></span>
    `;
    countryCheckContainer.appendChild(countryLabel);
    countryCheckContainer.appendChild(countrySwitch);

    // Switch pour la vérification des proxies
    const proxyCheckContainer = document.createElement("div");
    proxyCheckContainer.style.display = "flex";
    proxyCheckContainer.style.alignItems = "center";
    proxyCheckContainer.style.justifyContent = "space-between";

    const proxyLabel = document.createElement("span");
    proxyLabel.textContent = "check proxies";
    proxyLabel.style.color = "#ff0000";

    const proxySwitch = document.createElement("label");
    proxySwitch.className = "switch";
    proxySwitch.innerHTML = `
        <input type="checkbox" id="proxyCheck">
        <span class="slider"></span>
    `;
    proxyCheckContainer.appendChild(proxyLabel);
    proxyCheckContainer.appendChild(proxySwitch);

    // Ajouter les containers au switchesContainer
    switchesContainer.appendChild(countryCheckContainer);
    switchesContainer.appendChild(proxyCheckContainer);

    // Input pour ajouter un pays
    const inputContainer = document.createElement("div");
    inputContainer.style.marginBottom = "20px";
    inputContainer.style.display = "flex";
    inputContainer.style.gap = "10px";

    const input = document.createElement("input");
    input.type = "text";
    input.placeholder = "Code pays (ex: fr, be, ch)";
    input.style.flex = "1";
    input.style.padding = "10px";
    input.style.backgroundColor = "rgba(0, 0, 0, 0.8)";
    input.style.border = "1px solid #ff0000";
    input.style.borderRadius = "5px";
    input.style.color = "#ff0000";
    input.style.outline = "none";

    const addButton = document.createElement("button");
    addButton.textContent = "Ajouter";
    addButton.className = "menu-btn";
    addButton.onclick = () => {
        const countryCode = input.value.trim().toLowerCase();
        if (!countryCode) return;

        if (allowedCountries.has(countryCode)) {
            showNotification(`Le pays ${countryCode.toUpperCase()} est déjà dans la liste ❌`, "error");
            return;
        }
        
        fetch('countryallowed/update-countries.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ 
                action: 'add',
                countryCode: countryCode 
            })
        })
        .then(response => {
            if (!response.ok) {
                throw new Error('Erreur réseau');
            }
            return response.json();
        })
        .then(data => {
            if (data.status === 'success') {
                allowedCountries.add(countryCode);
                input.value = '';
                updateCountriesListDisplay(countriesList);
                showNotification(`Pays ${countryCode.toUpperCase()} ajouté avec succès ✅`);
            } else {
                throw new Error(data.message || 'Erreur lors de l\'ajout du pays');
            }
        })
        .catch(error => {
            loadExistingCountries().then(() => {
                updateCountriesListDisplay(countriesList);
            });
            showNotification("Erreur lors de l'ajout du pays ❌", "error");
        });
    };

    inputContainer.appendChild(input);
    inputContainer.appendChild(addButton);

    // Ajouter les éléments dans l'ordre
    container.appendChild(switchesContainer);
    container.appendChild(inputContainer);

    // Liste des pays
    const countriesList = document.createElement("div");
    countriesList.style.maxHeight = "300px";
    countriesList.style.overflowY = "auto";
    countriesList.style.marginTop = "20px";
    countriesList.style.scrollbarWidth = "thin";
    countriesList.style.scrollbarColor = "#ff0000 #1a1a1a";

    container.appendChild(countriesList);
    document.body.appendChild(container);

    // Ajouter les événements pour les switches
    countrySwitch.querySelector('input').addEventListener('change', function() {
        const isEnabled = this.checked;
        fetch('settings/update-settings.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({
                setting: 'country_check',
                value: isEnabled
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                showNotification(`Vérification des pays ${isEnabled ? 'activée' : 'désactivée'} ✅`);
            }
        })
        .catch(() => {
            showNotification("Erreur lors de la mise à jour des paramètres ❌", "error");
        });
    });

    proxySwitch.querySelector('input').addEventListener('change', function() {
        const isEnabled = this.checked;
        fetch('settings/update-settings.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({
                setting: 'proxy_check',
                value: isEnabled
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                showNotification(`Vérification des proxies ${isEnabled ? 'activée' : 'désactivée'} ✅`);
            }
        })
        .catch(() => {
            showNotification("Erreur lors de la mise à jour des paramètres ❌", "error");
        });
    });

    // Charger l'état initial des switches
    fetch('settings/get-settings.php')
        .then(response => response.json())
        .then(data => {
            countrySwitch.querySelector('input').checked = data.country_check;
            proxySwitch.querySelector('input').checked = data.proxy_check;
        })
        .catch(() => {
            showNotification("Erreur lors du chargement des paramètres ❌", "error");
        });

    // Charger et afficher les pays
    fetch('countryallowed/get-countries.php')
        .then(response => response.json())
        .then(data => {
            if (data.countries) {
                allowedCountries = new Set(data.countries);
                updateCountriesListDisplay(countriesList);
            }
        })
        .catch(error => {
            showNotification("Erreur lors du chargement des pays ❌", "error");
        });
}
    const countriesList = document.createElement("div");
    countriesList.style.maxHeight = "300px";
    countriesList.style.overflowY = "auto";
    countriesList.style.marginTop = "20px";
    countriesList.style.scrollbarWidth = "thin";
    countriesList.style.scrollbarColor = "#ff0000 #1a1a1a";

    container.appendChild(countriesList);
    document.body.appendChild(container);

    // AJOUTEZ LA FONCTION ICI
    function updateCountriesListDisplay(container) {
        container.innerHTML = '';
        
        // Mapping des codes pays vers les emojis drapeaux
        const countryFlags = {
            'fr': '🇫🇷',
            'be': '🇧🇪',
            'ch': '🇨🇭',
            'ar': '🇦🇷',
            'de': '🇩🇪',
            'ma': '🇲🇦',
            'tn': '🇹🇳',
            'dz': '🇩🇿',
            'us': '🇺🇸',
            'gb': '🇬🇧',
            'es': '🇪🇸',
            'it': '🇮🇹',
            'pt': '🇵🇹',
            'nl': '🇳🇱',
            'lu': '🇱🇺'
        };

        allowedCountries.forEach(country => {
            const countryItem = document.createElement("div");
            countryItem.style.display = "flex";
            countryItem.style.justifyContent = "space-between";
            countryItem.style.alignItems = "center";
            countryItem.style.padding = "10px";
            countryItem.style.borderBottom = "1px solid rgba(255, 0, 0, 0.3)";
            countryItem.style.color = "#ff0000";
            countryItem.style.marginBottom = "5px";

            const countryInfo = document.createElement("div");
            countryInfo.style.display = "flex";
            countryInfo.style.alignItems = "center";
            countryInfo.style.gap = "10px";

            const flag = document.createElement("span");
            flag.textContent = countryFlags[country.toLowerCase()] || '🏳️';
            flag.style.fontSize = "20px";

            const countryCode = document.createElement("span");
            countryCode.textContent = country.toUpperCase();
            countryCode.style.fontWeight = "bold";

            countryInfo.appendChild(flag);
            countryInfo.appendChild(countryCode);

            const removeButton = document.createElement("button");
            removeButton.innerHTML = "✕";
            removeButton.style.backgroundColor = "transparent";
            removeButton.style.border = "none";
            removeButton.style.color = "#ff0000";
            removeButton.style.cursor = "pointer";
            removeButton.style.padding = "5px 10px";
            removeButton.style.fontSize = "16px";
            removeButton.style.transition = "all 0.3s ease";

            removeButton.onmouseover = () => {
                removeButton.style.transform = "scale(1.1)";
                removeButton.style.color = "#ff3333";
            };
            removeButton.onmouseout = () => {
                removeButton.style.transform = "scale(1)";
                removeButton.style.color = "#ff0000";
            };

            removeButton.onclick = () => {
                fetch('countryallowed/update-countries.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({ 
                        action: 'remove',
                        countryCode: country 
                    })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.status === 'success') {
                        allowedCountries.delete(country);
                        updateCountriesListDisplay(container);
                        showNotification(`Pays ${countryFlags[country.toLowerCase()] || ''} ${country.toUpperCase()} retiré ✅`);
                    } else {
                        throw new Error(data.message);
                    }
                })
                .catch(error => {
                    showNotification("Erreur lors de la suppression du pays ❌", "error");
                });
            };

            countryItem.appendChild(countryInfo);
            countryItem.appendChild(removeButton);
            container.appendChild(countryItem);
        });
    }
</script>
<script src="../styles/js/blok.js"></script>
<script>
// Attendre que le DOM soit chargé
document.addEventListener('DOMContentLoaded', function() {
    addDeleteButtons();
    const menuContainer = document.querySelector('.menu-container');
    menuContainer.innerHTML = `
        <button class="menu-btn" onclick="showBanForm()">
            <svg viewBox="0 0 24 24">
                <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8 0-1.85.63-3.55 1.69-4.9L16.9 18.31C15.55 19.37 13.85 20 12 20zm6.31-3.1L7.1 5.69C8.45 4.63 10.15 4 12 4c4.42 0 8 3.58 8 8 0 1.85-.63 3.55-1.69 4.9z"/>
            </svg>
            Ban IP
        </button>
        <button class="menu-btn" onclick="showAllowedCountries()">
            <svg viewBox="0 0 24 24">
                <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-1 17.93c-3.95-.49-7-3.85-7-7.93 0-.62.08-1.21.21-1.79L9 15v1c0 1.1.9 2 2 2v1.93zm6.9-2.54c-.26-.81-1-1.39-1.9-1.39h-1v-3c0-.55-.45-1-1-1H8v-2h2c.55 0 1-.45 1-1V7h2c1.1 0 2-.9 2-2v-.41c2.93 1.19 5 4.06 5 7.41 0 2.08-.8 3.97-2.1 5.39z"/>
            </svg>
            Allowed Countries
        </button>
        <button class="menu-btn" onclick="showBannedIPs()">
            <svg viewBox="0 0 24 24">
                <path d="M16 1H8C6.34 1 5 2.34 5 4v16c0 1.66 1.34 3 3 3h8c1.66 0 3-1.34 3-3V4c0-1.66-1.34-3-3-3zm-2 20h-4v-1h4v1zm3.25-3H6.75V4h10.5v14z"/>
                <path d="M12 17h2v-6h-2v6zm0-8h2V7h-2v2z"/>
            </svg>
            Show Banned IPs
        </button>
        <button class="menu-btn" onclick="clearLogs()">
            <svg viewBox="0 0 24 24">
                <path d="M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6v12zM19 4h-3.5l-1-1h-5l-1 1H5v2h14V4z"/>
            </svg>
            Clear Logs
        </button>
        <button class="menu-btn" onclick="toggleIframe()">
            <svg viewBox="0 0 24 24">
                <path d="M3 13h8V3H3v10zm0 8h8v-6H3v6zm10 0h8V11h-8v10zm0-18v6h8V3h-8z"/>
            </svg>
            Status en temps réel
        </button>
    `;

    // Remplacer le bouton de fermeture
    const closeButton = document.querySelector('.close-menu');
    closeButton.innerHTML = `
        <svg viewBox="0 0 24 24">
            <path d="M18 6L6 18M6 6l12 12"/>
        </svg>
    `;
});
// delete logs
function addDeleteButtons() {
    const rows = document.querySelectorAll('#visitorTable tbody tr');
    rows.forEach(row => {
        const actionCell = document.createElement('td');
        actionCell.innerHTML = `
            <button class="delete-log-btn" onclick="deleteSpecificLog(this.parentElement.parentElement)">
                <svg class="delete-icon" viewBox="0 0 24 24" width="24" height="24">
                    <path d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" 
                          stroke="#ff0000" 
                          stroke-width="2" 
                          stroke-linecap="round" 
                          stroke-linejoin="round"
                          fill="none"/>
                </svg>
            </button>
        `;
        row.appendChild(actionCell);
    });
}
function deleteSpecificLog(row) {
    const ip = row.querySelector('td:first-child').textContent.trim().split(' ').pop();
    const date = row.querySelector('td:nth-child(2)').textContent.trim();

    if (confirm(`Voulez-vous vraiment supprimer ce log ?\nIP: ${ip}\nDate: ${date}`)) {
        // Effet de flash initial
        row.style.transition = 'background-color 0.2s';
        row.style.backgroundColor = 'rgba(255, 0, 0, 0.05)';
        
        setTimeout(() => {
            row.style.backgroundColor = '';
            row.classList.add('slice-delete');
            
            fetch('status/delete-specific-lo